
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Address representation choice.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:element ref="ns:AddressCore"/>
 *       &lt;xs:element ref="ns:AddressDetail"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Address implements Serializable
{
    private int addressSelect = -1;
    private static final int ADDRESS_CORE_CHOICE = 0;
    private static final int ADDRESS_DETAIL_CHOICE = 1;
    private AddressCoreType addressCore;
    private AddressDetailType addressDetail;

    private void setAddressSelect(int choice) {
        if (addressSelect == -1) {
            addressSelect = choice;
        } else if (addressSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearAddressSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearAddressSelect() {
        addressSelect = -1;
    }

    /** 
     * Check if AddressCore is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAddressCore() {
        return addressSelect == ADDRESS_CORE_CHOICE;
    }

    /** 
     * Get the 'AddressCore' element value.
     * 
     * @return value
     */
    public AddressCoreType getAddressCore() {
        return addressCore;
    }

    /** 
     * Set the 'AddressCore' element value.
     * 
     * @param addressCore
     */
    public void setAddressCore(AddressCoreType addressCore) {
        setAddressSelect(ADDRESS_CORE_CHOICE);
        this.addressCore = addressCore;
    }

    /** 
     * Check if AddressDetail is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAddressDetail() {
        return addressSelect == ADDRESS_DETAIL_CHOICE;
    }

    /** 
     * Get the 'AddressDetail' element value.
     * 
     * @return value
     */
    public AddressDetailType getAddressDetail() {
        return addressDetail;
    }

    /** 
     * Set the 'AddressDetail' element value.
     * 
     * @param addressDetail
     */
    public void setAddressDetail(AddressDetailType addressDetail) {
        setAddressSelect(ADDRESS_DETAIL_CHOICE);
        this.addressDetail = addressDetail;
    }
}
