
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * DETAIL ADDRESS representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddressDetailType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AddressCoreType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Directions" minOccurs="0">
 *           &lt;!-- Reference to inner class Directions -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AddressDetailType extends AddressCoreType implements Serializable
{
    private Directions directions;

    /** 
     * Get the 'Directions' element value.
     * 
     * @return value
     */
    public Directions getDirections() {
        return directions;
    }

    /** 
     * Set the 'Directions' element value.
     * 
     * @param directions
     */
    public void setDirections(Directions directions) {
        this.directions = directions;
    }
    /** 
     * Specifies directions to a given address (I.e. to service fulfilment address, if other than an airport)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Directions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:Direction" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Directions implements Serializable
    {
        private List<DirectionsType> directionList = new ArrayList<DirectionsType>();

        /** 
         * Get the list of 'Direction' element items.
         * 
         * @return list
         */
        public List<DirectionsType> getDirectionList() {
            return directionList;
        }

        /** 
         * Set the list of 'Direction' element items.
         * 
         * @param list
         */
        public void setDirectionList(List<DirectionsType> list) {
            directionList = list;
        }
    }
}
