
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for (AGENCY) AGENT USER Seller Role, Core Representation.

 Notes:
 1. This is a representation of common (role-agnostic) properties associated with this Actor definition.
 2. This type is used as (derived) base type for all Roles associated with this Actor.
 3. This type is derived from AgencyCoreRepType.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentUserType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AgencyCoreRepType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:UniqueIDContextType" name="AgentUserID"/>
 *         &lt;xs:element type="xs:string" name="UserRole" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AgentUserType extends AgencyCoreRepType implements Serializable
{
    private UniqueIDContextType agentUserID;
    private String userRole;

    /** 
     * Get the 'AgentUserID' element value. Agent User ID. Example: ksmith212
     * 
     * @return value
     */
    public UniqueIDContextType getAgentUserID() {
        return agentUserID;
    }

    /** 
     * Set the 'AgentUserID' element value. Agent User ID. Example: ksmith212
     * 
     * @param agentUserID
     */
    public void setAgentUserID(UniqueIDContextType agentUserID) {
        this.agentUserID = agentUserID;
    }

    /** 
     * Get the 'UserRole' element value. Agent role. Example: Authorized User
     * 
     * @return value
     */
    public String getUserRole() {
        return userRole;
    }

    /** 
     * Set the 'UserRole' element value. Agent role. Example: Authorized User
     * 
     * @param userRole
     */
    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }
}
