
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The AirDocIssue transaction set requests an Airline to issue flight (ET) and/or ancillary (EMD) document(s).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirDocIssueRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element ref="ns:TicketDocQuantity"/>
 *             &lt;xs:element name="TicketDocInfo" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class TicketDocInfo -->
 *             &lt;/xs:element>
 *             &lt;xs:element type="ns:DataListType" name="DataLists" minOccurs="0"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirDocIssueRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private TicketDocQuantity queryTicketDocQuantity;
    private List<TicketDocInfo> ticketDocInfoList = new ArrayList<TicketDocInfo>();
    private DataListType queryDataLists;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'TicketDocQuantity' element value.
     * 
     * @return value
     */
    public TicketDocQuantity getQueryTicketDocQuantity() {
        return queryTicketDocQuantity;
    }

    /** 
     * Set the 'TicketDocQuantity' element value.
     * 
     * @param queryTicketDocQuantity
     */
    public void setQueryTicketDocQuantity(
            TicketDocQuantity queryTicketDocQuantity) {
        this.queryTicketDocQuantity = queryTicketDocQuantity;
    }

    /** 
     * Get the list of 'TicketDocInfo' element items. Air Document Issue Request Query.
     * 
     * @return list
     */
    public List<TicketDocInfo> getTicketDocInfoList() {
        return ticketDocInfoList;
    }

    /** 
     * Set the list of 'TicketDocInfo' element items. Air Document Issue Request Query.
     * 
     * @param list
     */
    public void setTicketDocInfoList(List<TicketDocInfo> list) {
        ticketDocInfoList = list;
    }

    /** 
     * Get the 'DataLists' element value. Data Lists(s).
     * 
     * @return value
     */
    public DataListType getQueryDataLists() {
        return queryDataLists;
    }

    /** 
     * Set the 'DataLists' element value. Data Lists(s).
     * 
     * @param queryDataLists
     */
    public void setQueryDataLists(DataListType queryDataLists) {
        this.queryDataLists = queryDataLists;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Coupon Creation Information, including Traveler; Order/ Booking Reference ID(s); Promotions and Commission.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfo" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:TravelerInfo"/>
     *       &lt;xs:element ref="ns:BookingReference" minOccurs="0"/>
     *       &lt;xs:element type="ns:CouponOrderKeyType" name="OrderReference" minOccurs="0"/>
     *       &lt;xs:element name="Promotions" minOccurs="0">
     *         &lt;!-- Reference to inner class Promotions -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Payments" minOccurs="0">
     *         &lt;!-- Reference to inner class Payments -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FlightSegmentReferences" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketDocInfo implements Serializable
    {
        private TravelerInfo travelerInfo;
        private BookingReferenceType bookingReference;
        private CouponOrderKeyType orderReference;
        private Promotions promotions;
        private Payments payments;
        private CommissionType commission;
        private FlightSegmentReferences flightSegmentReferences;

        /** 
         * Get the 'TravelerInfo' element value. Traveler information, including name, passenger type and contact.

         * 
         * @return value
         */
        public TravelerInfo getTravelerInfo() {
            return travelerInfo;
        }

        /** 
         * Set the 'TravelerInfo' element value. Traveler information, including name, passenger type and contact.

         * 
         * @param travelerInfo
         */
        public void setTravelerInfo(TravelerInfo travelerInfo) {
            this.travelerInfo = travelerInfo;
        }

        /** 
         * Get the 'BookingReference' element value. Booking Reference information.

         * 
         * @return value
         */
        public BookingReferenceType getBookingReference() {
            return bookingReference;
        }

        /** 
         * Set the 'BookingReference' element value. Booking Reference information.

         * 
         * @param bookingReference
         */
        public void setBookingReference(BookingReferenceType bookingReference) {
            this.bookingReference = bookingReference;
        }

        /** 
         * Get the 'OrderReference' element value. The order id for which a ticket/document should be issued.
         * 
         * @return value
         */
        public CouponOrderKeyType getOrderReference() {
            return orderReference;
        }

        /** 
         * Set the 'OrderReference' element value. The order id for which a ticket/document should be issued.
         * 
         * @param orderReference
         */
        public void setOrderReference(CouponOrderKeyType orderReference) {
            this.orderReference = orderReference;
        }

        /** 
         * Get the 'Promotions' element value.
         * 
         * @return value
         */
        public Promotions getPromotions() {
            return promotions;
        }

        /** 
         * Set the 'Promotions' element value.
         * 
         * @param promotions
         */
        public void setPromotions(Promotions promotions) {
            this.promotions = promotions;
        }

        /** 
         * Get the 'Payments' element value.
         * 
         * @return value
         */
        public Payments getPayments() {
            return payments;
        }

        /** 
         * Set the 'Payments' element value.
         * 
         * @param payments
         */
        public void setPayments(Payments payments) {
            this.payments = payments;
        }

        /** 
         * Get the 'Commission' element value. Commission information
         * 
         * @return value
         */
        public CommissionType getCommission() {
            return commission;
        }

        /** 
         * Set the 'Commission' element value. Commission information
         * 
         * @param commission
         */
        public void setCommission(CommissionType commission) {
            this.commission = commission;
        }

        /** 
         * Get the 'FlightSegmentReferences' element value.
         * 
         * @return value
         */
        public FlightSegmentReferences getFlightSegmentReferences() {
            return flightSegmentReferences;
        }

        /** 
         * Set the 'FlightSegmentReferences' element value.
         * 
         * @param flightSegmentReferences
         */
        public void setFlightSegmentReferences(
                FlightSegmentReferences flightSegmentReferences) {
            this.flightSegmentReferences = flightSegmentReferences;
        }
        /** 
         * Promotion information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PromotionType" name="Promotion" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Promotions implements Serializable
        {
            private List<PromotionType> promotionList = new ArrayList<PromotionType>();

            /** 
             * Get the list of 'Promotion' element items. Promotion Code.
             * 
             * @return list
             */
            public List<PromotionType> getPromotionList() {
                return promotionList;
            }

            /** 
             * Set the list of 'Promotion' element items. Promotion Code.
             * 
             * @param list
             */
            public void setPromotionList(List<PromotionType> list) {
                promotionList = list;
            }
        }
        /** 
         * Payment information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:AcceptedPaymentFormType" name="Payment" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Payments implements Serializable
        {
            private List<AcceptedPaymentFormType> paymentList = new ArrayList<AcceptedPaymentFormType>();

            /** 
             * Get the list of 'Payment' element items. Payment detail.
             * 
             * @return list
             */
            public List<AcceptedPaymentFormType> getPaymentList() {
                return paymentList;
            }

            /** 
             * Set the list of 'Payment' element items. Payment detail.
             * 
             * @param list
             */
            public void setPaymentList(List<AcceptedPaymentFormType> list) {
                paymentList = list;
            }
        }
    }
}
