
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * The AirShopping transaction set supports both demanding and flexible shopping experiences for anonymous or personalized shopping.

 The combination of functionally-rich attribute and affinity shopping support date range or specific month (calendar) shopping as an example.

 The response returns offers which may include branded offers or itinerary-priced offers with or without ancillary services. It also returns applicable rules for the integrated fares as well as for each service.

 The message also returns multi-media content at message level as well as media references at the individual offer level.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirShoppingRS">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Document"/>
 *         &lt;xs:element type="ns:SuccessType" name="Success"/>
 *         &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *         &lt;xs:element ref="ns:AirShoppingProcessing"/>
 *         &lt;xs:element ref="ns:ShoppingResponseIDs" minOccurs="0"/>
 *         &lt;xs:element name="OffersGroup">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element ref="ns:AllOffersSnapshot" minOccurs="0"/>
 *               &lt;xs:element name="AirlineOffers" maxOccurs="unbounded">
 *                 &lt;!-- Reference to inner class AirlineOffers -->
 *               &lt;/xs:element>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Payments" minOccurs="0">
 *           &lt;!-- Reference to inner class Payments -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Promotions" minOccurs="0">
 *           &lt;!-- Reference to inner class Promotions -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:Commission" minOccurs="0"/>
 *         &lt;xs:element type="ns:DataListType" name="DataLists" minOccurs="0"/>
 *         &lt;xs:element type="ns:AirShopResMetadataType" name="Metadata" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:element ref="ns:Errors"/>
 *     &lt;/xs:choice>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AirShoppingRS implements Serializable
{
    private int choiceSelect = -1;
    private static final int DOCUMENT_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private MsgDocumentType document;
    private SuccessType success;
    private WarningsType warnings;
    private OrdViewProcessType airShoppingProcessing;
    private ShoppingResponseIDType shoppingResponseIDs;
    private AllOffersSnapshotType offersGroupAllOffersSnapshot;
    private List<AirlineOffers> airlineOfferList = new ArrayList<AirlineOffers>();
    private Payments payments;
    private Promotions promotions;
    private Commission commission;
    private DataListType dataLists;
    private AirShopResMetadataType metadata;
    private Policies policies;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Document is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDocument() {
        return choiceSelect == DOCUMENT_CHOICE;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.document = document;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'AirShoppingProcessing' element value.
     * 
     * @return value
     */
    public OrdViewProcessType getAirShoppingProcessing() {
        return airShoppingProcessing;
    }

    /** 
     * Set the 'AirShoppingProcessing' element value.
     * 
     * @param airShoppingProcessing
     */
    public void setAirShoppingProcessing(
            OrdViewProcessType airShoppingProcessing) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.airShoppingProcessing = airShoppingProcessing;
    }

    /** 
     * Get the 'ShoppingResponseIDs' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseIDs() {
        return shoppingResponseIDs;
    }

    /** 
     * Set the 'ShoppingResponseIDs' element value.
     * 
     * @param shoppingResponseIDs
     */
    public void setShoppingResponseIDs(
            ShoppingResponseIDType shoppingResponseIDs) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.shoppingResponseIDs = shoppingResponseIDs;
    }

    /** 
     * Get the 'AllOffersSnapshot' element value.
     * 
     * @return value
     */
    public AllOffersSnapshotType getOffersGroupAllOffersSnapshot() {
        return offersGroupAllOffersSnapshot;
    }

    /** 
     * Set the 'AllOffersSnapshot' element value.
     * 
     * @param offersGroupAllOffersSnapshot
     */
    public void setOffersGroupAllOffersSnapshot(
            AllOffersSnapshotType offersGroupAllOffersSnapshot) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.offersGroupAllOffersSnapshot = offersGroupAllOffersSnapshot;
    }

    /** 
     * Get the list of 'AirlineOffers' element items. Offers Grouped by Airline Supplier.
     * 
     * @return list
     */
    public List<AirlineOffers> getAirlineOfferList() {
        return airlineOfferList;
    }

    /** 
     * Set the list of 'AirlineOffers' element items. Offers Grouped by Airline Supplier.
     * 
     * @param list
     */
    public void setAirlineOfferList(List<AirlineOffers> list) {
        setChoiceSelect(DOCUMENT_CHOICE);
        airlineOfferList = list;
    }

    /** 
     * Get the 'Payments' element value.
     * 
     * @return value
     */
    public Payments getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value.
     * 
     * @param payments
     */
    public void setPayments(Payments payments) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.payments = payments;
    }

    /** 
     * Get the 'Promotions' element value.
     * 
     * @return value
     */
    public Promotions getPromotions() {
        return promotions;
    }

    /** 
     * Set the 'Promotions' element value.
     * 
     * @param promotions
     */
    public void setPromotions(Promotions promotions) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.promotions = promotions;
    }

    /** 
     * Get the 'Commission' element value.
     * 
     * @return value
     */
    public Commission getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value.
     * 
     * @param commission
     */
    public void setCommission(Commission commission) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.commission = commission;
    }

    /** 
     * Get the 'DataLists' element value. Data Lists(s).
     * 
     * @return value
     */
    public DataListType getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value. Data Lists(s).
     * 
     * @param dataLists
     */
    public void setDataLists(DataListType dataLists) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public AirShopResMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(AirShopResMetadataType metadata) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.policies = policies;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Airline Offer(s) grouped by Airline Designator.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineOffers" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="TotalOfferQuantity" minOccurs="0"/>
     *       &lt;xs:element ref="ns:AirlineOfferSnapshot" minOccurs="0"/>
     *       &lt;xs:element type="ns:AirlineID_Type" name="Owner" minOccurs="0"/>
     *       &lt;xs:element name="AirlineOffer" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AirlineOffer -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PriceCalendar" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PriceCalendar -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AirlineOffers implements Serializable
    {
        private String totalOfferQuantity;
        private AirlineOffersSnapshotType airlineOfferSnapshot;
        private AirlineIDType owner;
        private List<AirlineOffer> airlineOfferList = new ArrayList<AirlineOffer>();
        private List<PriceCalendar> priceCalendarList = new ArrayList<PriceCalendar>();

        /** 
         * Get the 'TotalOfferQuantity' element value. The total number of Offers provided by this Airline. Example: 12
         * 
         * @return value
         */
        public String getTotalOfferQuantity() {
            return totalOfferQuantity;
        }

        /** 
         * Set the 'TotalOfferQuantity' element value. The total number of Offers provided by this Airline. Example: 12
         * 
         * @param totalOfferQuantity
         */
        public void setTotalOfferQuantity(String totalOfferQuantity) {
            this.totalOfferQuantity = totalOfferQuantity;
        }

        /** 
         * Get the 'AirlineOfferSnapshot' element value.
         * 
         * @return value
         */
        public AirlineOffersSnapshotType getAirlineOfferSnapshot() {
            return airlineOfferSnapshot;
        }

        /** 
         * Set the 'AirlineOfferSnapshot' element value.
         * 
         * @param airlineOfferSnapshot
         */
        public void setAirlineOfferSnapshot(
                AirlineOffersSnapshotType airlineOfferSnapshot) {
            this.airlineOfferSnapshot = airlineOfferSnapshot;
        }

        /** 
         * Get the 'Owner' element value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

        Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
         * 
         * @return value
         */
        public AirlineIDType getOwner() {
            return owner;
        }

        /** 
         * Set the 'Owner' element value. Airline designator of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

        Encoding Scheme: IATA/ A4A (two or three character) Airline Designator Code
         * 
         * @param owner
         */
        public void setOwner(AirlineIDType owner) {
            this.owner = owner;
        }

        /** 
         * Get the list of 'AirlineOffer' element items.
         * 
         * @return list
         */
        public List<AirlineOffer> getAirlineOfferList() {
            return airlineOfferList;
        }

        /** 
         * Set the list of 'AirlineOffer' element items.
         * 
         * @param list
         */
        public void setAirlineOfferList(List<AirlineOffer> list) {
            airlineOfferList = list;
        }

        /** 
         * Get the list of 'PriceCalendar' element items.
         * 
         * @return list
         */
        public List<PriceCalendar> getPriceCalendarList() {
            return priceCalendarList;
        }

        /** 
         * Set the list of 'PriceCalendar' element items.
         * 
         * @param list
         */
        public void setPriceCalendarList(List<PriceCalendar> list) {
            priceCalendarList = list;
        }
        /** 
         * Airline Offer Detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineOffer" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:OfferItemDetailType">
         *         &lt;xs:sequence>
         *           &lt;xs:element ref="ns:PricedOffer" minOccurs="0"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AirlineOffer extends OfferItemDetailType implements
            Serializable
        {
            private PricedFlightOfferType pricedOffer;

            /** 
             * Get the 'PricedOffer' element value.
             * 
             * @return value
             */
            public PricedFlightOfferType getPricedOffer() {
                return pricedOffer;
            }

            /** 
             * Set the 'PricedOffer' element value.
             * 
             * @param pricedOffer
             */
            public void setPricedOffer(PricedFlightOfferType pricedOffer) {
                this.pricedOffer = pricedOffer;
            }
        }
        /** 
         * Calendar based Flight Price.

        Note: this contains lead-based flight prices for the requested travel date and requested lead calendar period.

        This capability supports multi-day calendar shopping, e.g. returning priced flight offers for a specified period before and/or after the actual requested date.

        The mandatory PriceCalendarDate contains the date associated with the price. If it is a lead calendar price, the @LeadPriceInd should be set to true. 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceCalendar" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="PriceCalendarDate" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class PriceCalendarDate -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:CurrencyAmountEncodedType" name="TotalPrice"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:anySimpleType" name="LeadPriceInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceCalendar implements Serializable
        {
            private List<PriceCalendarDate> priceCalendarDateList = new ArrayList<PriceCalendarDate>();
            private CurrencyAmountEncodedType totalPrice;
            private String leadPriceInd;

            /** 
             * Get the list of 'PriceCalendarDate' element items.
             * 
             * @return list
             */
            public List<PriceCalendarDate> getPriceCalendarDateList() {
                return priceCalendarDateList;
            }

            /** 
             * Set the list of 'PriceCalendarDate' element items.
             * 
             * @param list
             */
            public void setPriceCalendarDateList(List<PriceCalendarDate> list) {
                priceCalendarDateList = list;
            }

            /** 
             * Get the 'TotalPrice' element value. The total price for all Travelers associated with this offer.
             * 
             * @return value
             */
            public CurrencyAmountEncodedType getTotalPrice() {
                return totalPrice;
            }

            /** 
             * Set the 'TotalPrice' element value. The total price for all Travelers associated with this offer.
             * 
             * @param totalPrice
             */
            public void setTotalPrice(CurrencyAmountEncodedType totalPrice) {
                this.totalPrice = totalPrice;
            }

            /** 
             * Get the 'LeadPriceInd' attribute value. When TRUE, this is a lead calendar shopping price for a date that is prior to or after the required travel date.
             * 
             * @return value
             */
            public String getLeadPriceInd() {
                return leadPriceInd;
            }

            /** 
             * Set the 'LeadPriceInd' attribute value. When TRUE, this is a lead calendar shopping price for a date that is prior to or after the required travel date.
             * 
             * @param leadPriceInd
             */
            public void setLeadPriceInd(String leadPriceInd) {
                this.leadPriceInd = leadPriceInd;
            }
            /** 
             * Price calendar date, example 2015-04-25. [Encoding Scheme] ISO 8601 Date Format (YYYY-MM-DD)
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceCalendarDate" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:date">
             *         &lt;xs:attribute type="xs:string" name="OriginDestinationReference"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PriceCalendarDate implements Serializable
            {
                private Date date;
                private String originDestinationReference;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public Date getDate() {
                    return date;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param date
                 */
                public void setDate(Date date) {
                    this.date = date;
                }

                /** 
                 * Get the 'OriginDestinationReference' attribute value. Association to one Origin/Destination instance. Example: od1
                 * 
                 * @return value
                 */
                public String getOriginDestinationReference() {
                    return originDestinationReference;
                }

                /** 
                 * Set the 'OriginDestinationReference' attribute value. Association to one Origin/Destination instance. Example: od1
                 * 
                 * @param originDestinationReference
                 */
                public void setOriginDestinationReference(
                        String originDestinationReference) {
                    this.originDestinationReference = originDestinationReference;
                }
            }
        }
    }
    /** 
     * Payment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:OrderPaymentFormType" name="Payment" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payments implements Serializable
    {
        private List<OrderPaymentFormType> paymentList = new ArrayList<OrderPaymentFormType>();

        /** 
         * Get the list of 'Payment' element items. Payment detail, including association(s).
         * 
         * @return list
         */
        public List<OrderPaymentFormType> getPaymentList() {
            return paymentList;
        }

        /** 
         * Set the list of 'Payment' element items. Payment detail, including association(s).
         * 
         * @param list
         */
        public void setPaymentList(List<OrderPaymentFormType> list) {
            paymentList = list;
        }
    }
    /** 
     * Promotion information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PromotionType" name="Promotion" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Promotions implements Serializable
    {
        private List<PromotionType> promotionList = new ArrayList<PromotionType>();

        /** 
         * Get the list of 'Promotion' element items. Promotion Code.
         * 
         * @return list
         */
        public List<PromotionType> getPromotionList() {
            return promotionList;
        }

        /** 
         * Set the list of 'Promotion' element items. Promotion Code.
         * 
         * @param list
         */
        public void setPromotionList(List<PromotionType> list) {
            promotionList = list;
        }
    }
}
