
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AIRCRAFT EQUIPMENT CODE QUERY representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AircraftCodeQueryType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:AircraftCode" maxOccurs="unbounded"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AircraftCodeQueryType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private List<AircraftCodeType> aircraftCodeList = new ArrayList<AircraftCodeType>();

    /** 
     * Get the list of 'AircraftCode' element items. The IATA aircraft type 3 character code; use SSIM Appendix A. Example:318.
     * 
     * @return list
     */
    public List<AircraftCodeType> getAircraftCodeList() {
        return aircraftCodeList;
    }

    /** 
     * Set the list of 'AircraftCode' element items. The IATA aircraft type 3 character code; use SSIM Appendix A. Example:318.
     * 
     * @param list
     */
    public void setAircraftCodeList(List<AircraftCodeType> list) {
        aircraftCodeList = list;
    }
}
