
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * AIRCRAFT CORE representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AircraftCoreType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:AircraftCode"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="ChangeOfGaugeInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AircraftCoreType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private AircraftCodeType aircraftCode;
    private Boolean changeOfGaugeInd;

    /** 
     * Get the 'AircraftCode' element value. Equipment Code. Example: 737

    Encoding Scheme: IATA/ A4A Equipment Code
     * 
     * @return value
     */
    public AircraftCodeType getAircraftCode() {
        return aircraftCode;
    }

    /** 
     * Set the 'AircraftCode' element value. Equipment Code. Example: 737

    Encoding Scheme: IATA/ A4A Equipment Code
     * 
     * @param aircraftCode
     */
    public void setAircraftCode(AircraftCodeType aircraftCode) {
        this.aircraftCode = aircraftCode;
    }

    /** 
     * Get the 'ChangeOfGaugeInd' attribute value. When TUE, this aircraft equipment information is associated with a flight change of gauge.
     * 
     * @return value
     */
    public Boolean getChangeOfGaugeInd() {
        return changeOfGaugeInd;
    }

    /** 
     * Set the 'ChangeOfGaugeInd' attribute value. When TUE, this aircraft equipment information is associated with a flight change of gauge.
     * 
     * @param changeOfGaugeInd
     */
    public void setChangeOfGaugeInd(Boolean changeOfGaugeInd) {
        this.changeOfGaugeInd = changeOfGaugeInd;
    }
}
