
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AIRLINE SUPPLIER Preferences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlinePreferencesType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Airline" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Airline -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirlinePreferencesType extends AssociatedObjectBaseType implements
    Serializable
{
    private List<Airline> airlineList = new ArrayList<Airline>();

    /** 
     * Get the list of 'Airline' element items.
     * 
     * @return list
     */
    public List<Airline> getAirlineList() {
        return airlineList;
    }

    /** 
     * Set the list of 'Airline' element items.
     * 
     * @param list
     */
    public void setAirlineList(List<Airline> list) {
        airlineList = list;
    }
    /** 
     * Airline Supplier information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:AirlineID"/>
     *       &lt;xs:element type="ns:CodesetType" name="GeoIndicatorType" minOccurs="0"/>
     *       &lt;xs:element type="ns:CodesetType" name="FlightHaulLength" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *     &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Airline implements Serializable
    {
        private AirlineIDType airlineID;
        private CodesetType geoIndicatorType;
        private CodesetType flightHaulLength;
        private String refs;
        private PreferenceAttrGroup preferenceAttrGroup;

        /** 
         * Get the 'AirlineID' element value.
         * 
         * @return value
         */
        public AirlineIDType getAirlineID() {
            return airlineID;
        }

        /** 
         * Set the 'AirlineID' element value.
         * 
         * @param airlineID
         */
        public void setAirlineID(AirlineIDType airlineID) {
            this.airlineID = airlineID;
        }

        /** 
         * Get the 'GeoIndicatorType' element value. Geographical indicator type.  Example: DOM (DOMESTIC/ DOMESTIC)

        Encoding Scheme: IATA Padis Codeset - List for data element 9970 (Product Details Qualifier)
         * 
         * @return value
         */
        public CodesetType getGeoIndicatorType() {
            return geoIndicatorType;
        }

        /** 
         * Set the 'GeoIndicatorType' element value. Geographical indicator type.  Example: DOM (DOMESTIC/ DOMESTIC)

        Encoding Scheme: IATA Padis Codeset - List for data element 9970 (Product Details Qualifier)
         * 
         * @param geoIndicatorType
         */
        public void setGeoIndicatorType(CodesetType geoIndicatorType) {
            this.geoIndicatorType = geoIndicatorType;
        }

        /** 
         * Get the 'FlightHaulLength' element value. Flight haul length type.  Example: LH (LONG-HAUL 6 HRS PLUS)

        Encoding Scheme: IATA Padis Codeset - List for data element FHT (Flight Haul Type)
         * 
         * @return value
         */
        public CodesetType getFlightHaulLength() {
            return flightHaulLength;
        }

        /** 
         * Set the 'FlightHaulLength' element value. Flight haul length type.  Example: LH (LONG-HAUL 6 HRS PLUS)

        Encoding Scheme: IATA Padis Codeset - List for data element FHT (Flight Haul Type)
         * 
         * @param flightHaulLength
         */
        public void setFlightHaulLength(CodesetType flightHaulLength) {
            this.flightHaulLength = flightHaulLength;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }

        /** 
         * Get the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public PreferenceAttrGroup getPreferenceAttrGroup() {
            return preferenceAttrGroup;
        }

        /** 
         * Set the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @param preferenceAttrGroup
         */
        public void setPreferenceAttrGroup(
                PreferenceAttrGroup preferenceAttrGroup) {
            this.preferenceAttrGroup = preferenceAttrGroup;
        }
    }
}
