
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type definition for Other Date/ Time Period Representation. Includes: Day of week number, Month number, Short Month and Short Year, Full Year, Full Year and Short Month.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AllDateGrpType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="MonthYear"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Year"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="YearMonth"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DayNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MonthNumber"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AllDateGrpType implements Serializable
{
    private String monthYear;
    private String year;
    private String yearMonth;
    private String dayNumber;
    private String monthNumber;

    /** 
     * Get the 'MonthYear' attribute value. A short month and year. Example: 01-17 (January 2017)
     * 
     * @return value
     */
    public String getMonthYear() {
        return monthYear;
    }

    /** 
     * Set the 'MonthYear' attribute value. A short month and year. Example: 01-17 (January 2017)
     * 
     * @param monthYear
     */
    public void setMonthYear(String monthYear) {
        this.monthYear = monthYear;
    }

    /** 
     * Get the 'Year' attribute value. A full year. Example: 2017
     * 
     * @return value
     */
    public String getYear() {
        return year;
    }

    /** 
     * Set the 'Year' attribute value. A full year. Example: 2017
     * 
     * @param year
     */
    public void setYear(String year) {
        this.year = year;
    }

    /** 
     * Get the 'YearMonth' attribute value. A full year and a short month. Example: 2017-01
     * 
     * @return value
     */
    public String getYearMonth() {
        return yearMonth;
    }

    /** 
     * Set the 'YearMonth' attribute value. A full year and a short month. Example: 2017-01
     * 
     * @param yearMonth
     */
    public void setYearMonth(String yearMonth) {
        this.yearMonth = yearMonth;
    }

    /** 
     * Get the 'DayNumber' attribute value. A day of the week number. Example: 01 (Monday)
     * 
     * @return value
     */
    public String getDayNumber() {
        return dayNumber;
    }

    /** 
     * Set the 'DayNumber' attribute value. A day of the week number. Example: 01 (Monday)
     * 
     * @param dayNumber
     */
    public void setDayNumber(String dayNumber) {
        this.dayNumber = dayNumber;
    }

    /** 
     * Get the 'MonthNumber' attribute value. A month number. Example: 01 (January)
     * 
     * @return value
     */
    public String getMonthNumber() {
        return monthNumber;
    }

    /** 
     * Set the 'MonthNumber' attribute value. A month number. Example: 01 (January)
     * 
     * @param monthNumber
     */
    public void setMonthNumber(String monthNumber) {
        this.monthNumber = monthNumber;
    }
}
