
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Aggregated Optional Service Offers Snapshot.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AllOffersSnapshotType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="TravelerQuantity"/>
 *         &lt;xs:element ref="ns:AssociatedTraveler" minOccurs="0"/>
 *         &lt;xs:choice>
 *           &lt;xs:element name="SubTotal" minOccurs="0">
 *             &lt;!-- Reference to inner class SubTotal -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="Highest" minOccurs="0">
 *             &lt;!-- Reference to inner class Highest -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="Lowest" minOccurs="0">
 *             &lt;!-- Reference to inner class Lowest -->
 *           &lt;/xs:element>
 *         &lt;/xs:choice>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AllOffersSnapshotType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private String travelerQuantity;
    private TravelerInfoAssocType associatedTraveler;
    private int choiceSelect = -1;
    private static final int SUB_TOTAL_CHOICE = 0;
    private static final int HIGHEST_CHOICE = 1;
    private static final int LOWEST_CHOICE = 2;
    private SubTotal subTotal;
    private Highest highest;
    private Lowest lowest;

    /** 
     * Get the 'TravelerQuantity' element value. Total number of Travelers priced for all passenger types (PTC). Example: 2
     * 
     * @return value
     */
    public String getTravelerQuantity() {
        return travelerQuantity;
    }

    /** 
     * Set the 'TravelerQuantity' element value. Total number of Travelers priced for all passenger types (PTC). Example: 2
     * 
     * @param travelerQuantity
     */
    public void setTravelerQuantity(String travelerQuantity) {
        this.travelerQuantity = travelerQuantity;
    }

    /** 
     * Get the 'AssociatedTraveler' element value.
     * 
     * @return value
     */
    public TravelerInfoAssocType getAssociatedTraveler() {
        return associatedTraveler;
    }

    /** 
     * Set the 'AssociatedTraveler' element value.
     * 
     * @param associatedTraveler
     */
    public void setAssociatedTraveler(TravelerInfoAssocType associatedTraveler) {
        this.associatedTraveler = associatedTraveler;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if SubTotal is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSubTotal() {
        return choiceSelect == SUB_TOTAL_CHOICE;
    }

    /** 
     * Get the 'SubTotal' element value.
     * 
     * @return value
     */
    public SubTotal getSubTotal() {
        return subTotal;
    }

    /** 
     * Set the 'SubTotal' element value.
     * 
     * @param subTotal
     */
    public void setSubTotal(SubTotal subTotal) {
        setChoiceSelect(SUB_TOTAL_CHOICE);
        this.subTotal = subTotal;
    }

    /** 
     * Check if Highest is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifHighest() {
        return choiceSelect == HIGHEST_CHOICE;
    }

    /** 
     * Get the 'Highest' element value.
     * 
     * @return value
     */
    public Highest getHighest() {
        return highest;
    }

    /** 
     * Set the 'Highest' element value.
     * 
     * @param highest
     */
    public void setHighest(Highest highest) {
        setChoiceSelect(HIGHEST_CHOICE);
        this.highest = highest;
    }

    /** 
     * Check if Lowest is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLowest() {
        return choiceSelect == LOWEST_CHOICE;
    }

    /** 
     * Get the 'Lowest' element value.
     * 
     * @return value
     */
    public Lowest getLowest() {
        return lowest;
    }

    /** 
     * Set the 'Lowest' element value.
     * 
     * @param lowest
     */
    public void setLowest(Lowest lowest) {
        setChoiceSelect(LOWEST_CHOICE);
        this.lowest = lowest;
    }
    /** 
     * Sub-totaled Price for all Travelers (of all types) and all Offer Item(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubTotal" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
     *       &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
     *       &lt;xs:element ref="ns:DetailCurrencyPrice"/>
     *       &lt;xs:element ref="ns:CombinationPricing"/>
     *       &lt;xs:element ref="ns:AwardPricing"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class SubTotal implements Serializable
    {
        private SimpleCurrencyPrice simpleCurrencyPrice;
        private EncodedCurrencyPrice encodedCurrencyPrice;
        private DetailCurrencyPriceType detailCurrencyPrice;
        private CombinationPriceType combinationPricing;
        private AwardPriceUnitType awardPricing;
        private String refs;

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getSimpleCurrencyPrice() {
            return simpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param simpleCurrencyPrice
         */
        public void setSimpleCurrencyPrice(
                SimpleCurrencyPrice simpleCurrencyPrice) {
            this.simpleCurrencyPrice = simpleCurrencyPrice;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getEncodedCurrencyPrice() {
            return encodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param encodedCurrencyPrice
         */
        public void setEncodedCurrencyPrice(
                EncodedCurrencyPrice encodedCurrencyPrice) {
            this.encodedCurrencyPrice = encodedCurrencyPrice;
        }

        /** 
         * Get the 'DetailCurrencyPrice' element value.
         * 
         * @return value
         */
        public DetailCurrencyPriceType getDetailCurrencyPrice() {
            return detailCurrencyPrice;
        }

        /** 
         * Set the 'DetailCurrencyPrice' element value.
         * 
         * @param detailCurrencyPrice
         */
        public void setDetailCurrencyPrice(
                DetailCurrencyPriceType detailCurrencyPrice) {
            this.detailCurrencyPrice = detailCurrencyPrice;
        }

        /** 
         * Get the 'CombinationPricing' element value.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            this.combinationPricing = combinationPricing;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            this.awardPricing = awardPricing;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Highest Price for all Travelers (of all types) and all Offer Item(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Highest" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
     *       &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
     *       &lt;xs:element ref="ns:DetailCurrencyPrice"/>
     *       &lt;xs:element ref="ns:CombinationPricing"/>
     *       &lt;xs:element ref="ns:AwardPricing"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Highest implements Serializable
    {
        private SimpleCurrencyPrice simpleCurrencyPrice;
        private EncodedCurrencyPrice encodedCurrencyPrice;
        private DetailCurrencyPriceType detailCurrencyPrice;
        private CombinationPriceType combinationPricing;
        private AwardPriceUnitType awardPricing;
        private String refs;

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getSimpleCurrencyPrice() {
            return simpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param simpleCurrencyPrice
         */
        public void setSimpleCurrencyPrice(
                SimpleCurrencyPrice simpleCurrencyPrice) {
            this.simpleCurrencyPrice = simpleCurrencyPrice;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getEncodedCurrencyPrice() {
            return encodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param encodedCurrencyPrice
         */
        public void setEncodedCurrencyPrice(
                EncodedCurrencyPrice encodedCurrencyPrice) {
            this.encodedCurrencyPrice = encodedCurrencyPrice;
        }

        /** 
         * Get the 'DetailCurrencyPrice' element value.
         * 
         * @return value
         */
        public DetailCurrencyPriceType getDetailCurrencyPrice() {
            return detailCurrencyPrice;
        }

        /** 
         * Set the 'DetailCurrencyPrice' element value.
         * 
         * @param detailCurrencyPrice
         */
        public void setDetailCurrencyPrice(
                DetailCurrencyPriceType detailCurrencyPrice) {
            this.detailCurrencyPrice = detailCurrencyPrice;
        }

        /** 
         * Get the 'CombinationPricing' element value.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            this.combinationPricing = combinationPricing;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            this.awardPricing = awardPricing;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Lowest Price for all Travelers (of all types) and all Offer Item(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Lowest" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
     *       &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
     *       &lt;xs:element ref="ns:DetailCurrencyPrice"/>
     *       &lt;xs:element ref="ns:CombinationPricing"/>
     *       &lt;xs:element ref="ns:AwardPricing"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Lowest implements Serializable
    {
        private SimpleCurrencyPrice simpleCurrencyPrice;
        private EncodedCurrencyPrice encodedCurrencyPrice;
        private DetailCurrencyPriceType detailCurrencyPrice;
        private CombinationPriceType combinationPricing;
        private AwardPriceUnitType awardPricing;
        private String refs;

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getSimpleCurrencyPrice() {
            return simpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param simpleCurrencyPrice
         */
        public void setSimpleCurrencyPrice(
                SimpleCurrencyPrice simpleCurrencyPrice) {
            this.simpleCurrencyPrice = simpleCurrencyPrice;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getEncodedCurrencyPrice() {
            return encodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param encodedCurrencyPrice
         */
        public void setEncodedCurrencyPrice(
                EncodedCurrencyPrice encodedCurrencyPrice) {
            this.encodedCurrencyPrice = encodedCurrencyPrice;
        }

        /** 
         * Get the 'DetailCurrencyPrice' element value.
         * 
         * @return value
         */
        public DetailCurrencyPriceType getDetailCurrencyPrice() {
            return detailCurrencyPrice;
        }

        /** 
         * Set the 'DetailCurrencyPrice' element value.
         * 
         * @param detailCurrencyPrice
         */
        public void setDetailCurrencyPrice(
                DetailCurrencyPriceType detailCurrencyPrice) {
            this.detailCurrencyPrice = detailCurrencyPrice;
        }

        /** 
         * Get the 'CombinationPricing' element value.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            this.combinationPricing = combinationPricing;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            this.awardPricing = awardPricing;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
