
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * S5 record attributes definition.ENCODING: Note, Attributes on the Services Record S5 that can be used as filter criteria for a service.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AttributesType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Group">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element type="xs:string" name="Code"/>
 *               &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="SubGroup" minOccurs="0">
 *           &lt;!-- Reference to inner class SubGroup -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Desc1" minOccurs="0">
 *           &lt;!-- Reference to inner class Desc1 -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Desc2" minOccurs="0">
 *           &lt;!-- Reference to inner class Desc2 -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AttributesType extends AssociatedObjectBaseType implements
    Serializable
{
    private String groupCode;
    private String groupText;
    private SubGroup subGroup;
    private Desc1 desc1;
    private Desc2 desc2;

    /** 
     * Get the 'Code' element value. Service Group code.

    BD (BUNDLED SERVICE)
    BG (BAGGAGE)
    IE (IN-FLIGHT ENTERTAINMENT)
    LG (LOUNGE)

     * 
     * @return value
     */
    public String getGroupCode() {
        return groupCode;
    }

    /** 
     * Set the 'Code' element value. Service Group code.

    BD (BUNDLED SERVICE)
    BG (BAGGAGE)
    IE (IN-FLIGHT ENTERTAINMENT)
    LG (LOUNGE)

     * 
     * @param groupCode
     */
    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    /** 
     * Get the 'Text' element value. Service group description.
    Example: BAGGAGE OPTIONS
     * 
     * @return value
     */
    public String getGroupText() {
        return groupText;
    }

    /** 
     * Set the 'Text' element value. Service group description.
    Example: BAGGAGE OPTIONS
     * 
     * @param groupText
     */
    public void setGroupText(String groupText) {
        this.groupText = groupText;
    }

    /** 
     * Get the 'SubGroup' element value.
     * 
     * @return value
     */
    public SubGroup getSubGroup() {
        return subGroup;
    }

    /** 
     * Set the 'SubGroup' element value.
     * 
     * @param subGroup
     */
    public void setSubGroup(SubGroup subGroup) {
        this.subGroup = subGroup;
    }

    /** 
     * Get the 'Desc1' element value.
     * 
     * @return value
     */
    public Desc1 getDesc1() {
        return desc1;
    }

    /** 
     * Set the 'Desc1' element value.
     * 
     * @param desc1
     */
    public void setDesc1(Desc1 desc1) {
        this.desc1 = desc1;
    }

    /** 
     * Get the 'Desc2' element value.
     * 
     * @return value
     */
    public Desc2 getDesc2() {
        return desc2;
    }

    /** 
     * Set the 'Desc2' element value.
     * 
     * @param desc2
     */
    public void setDesc2(Desc2 desc2) {
        this.desc2 = desc2;
    }
    /** 
     * Service subgroup information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubGroup" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Code"/>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SubGroup implements Serializable
    {
        private String code;
        private String text;

        /** 
         * Get the 'Code' element value. Service Sub-Group Code(s).

        Group BG: CT (Container), PP (Pre-Paid Excess Baggage)
        Group IE: IT (Internet Access), TV (Television)
        ENCODING: Note, Standard Group and Sub Group on the Services Record S5 that can be used as filter criteria for a service.

         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' element value. Service Sub-Group Code(s).

        Group BG: CT (Container), PP (Pre-Paid Excess Baggage)
        Group IE: IT (Internet Access), TV (Television)
        ENCODING: Note, Standard Group and Sub Group on the Services Record S5 that can be used as filter criteria for a service.

         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'Text' element value. Service subgroup description.
        Example: CARRY ON HAND BAGGAGE
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value. Service subgroup description.
        Example: CARRY ON HAND BAGGAGE
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }
    }
    /** 
     * Description 1 codes.ENCODING: Note, standard Description codes (or text translation for these codes) on the Optional Services Record S5.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Desc1" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Code"/>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Desc1 implements Serializable
    {
        private String code;
        private String text;

        /** 
         * Get the 'Code' element value. Description code.
        Example: 05 (UP TO 5 KG)=sample values=
        05 = up to 5 kg
        1Y = One Year
        AI = Aisle
        B1 = First Bag
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' element value. Description code.
        Example: 05 (UP TO 5 KG)=sample values=
        05 = up to 5 kg
        1Y = One Year
        AI = Aisle
        B1 = First Bag
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'Text' element value. Description code text.
        Example: UP TO 5 KG
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value. Description code text.
        Example: UP TO 5 KG
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }
    }
    /** 
     * Description 2 codes.ENCODING: Note, standard Description codes (or text translation for these codes) on the Optional Services Record S5.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Desc2" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Code"/>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Desc2 implements Serializable
    {
        private String code;
        private String text;

        /** 
         * Get the 'Code' element value. Description code.
        Example: HT (HOT)
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' element value. Description code.
        Example: HT (HOT)
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'Text' element value. Description code text.
        Example: HOT
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value. Description code text.
        Example: HOT
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }
    }
}
