
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type definition for Augmentation Point Association.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AugPointAssocType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="AugPointAssoc" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class AugPointAssoc -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Owner"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AugPointAssocType implements Serializable
{
    private List<AugPointAssoc> augPointAssocList = new ArrayList<AugPointAssoc>();
    private String owner;

    /** 
     * Get the list of 'AugPointAssoc' element items.
     * 
     * @return list
     */
    public List<AugPointAssoc> getAugPointAssocList() {
        return augPointAssocList;
    }

    /** 
     * Set the list of 'AugPointAssoc' element items.
     * 
     * @param list
     */
    public void setAugPointAssocList(List<AugPointAssoc> list) {
        augPointAssocList = list;
    }

    /** 
     * Get the 'Owner' attribute value. Owner Airline (or other entity) Code. Examples: BA, WIDGETCO
     * 
     * @return value
     */
    public String getOwner() {
        return owner;
    }

    /** 
     * Set the 'Owner' attribute value. Owner Airline (or other entity) Code. Examples: BA, WIDGETCO
     * 
     * @param owner
     */
    public void setOwner(String owner) {
        this.owner = owner;
    }
    /** 
     * Augmentation Point Association detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AugPointAssoc" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="KeyRef"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Owner"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Seq"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AugPointAssoc implements Serializable
    {
        private String keyRef;
        private String owner;
        private BigInteger seq;

        /** 
         * Get the 'KeyRef' attribute value. Reference to globally unique AUGMENTATION POINT instance/ class Key.

        Example: 2B75C565-5BB0- 4DCE-8DE6-67CB7B4F25A7
         * 
         * @return value
         */
        public String getKeyRef() {
            return keyRef;
        }

        /** 
         * Set the 'KeyRef' attribute value. Reference to globally unique AUGMENTATION POINT instance/ class Key.

        Example: 2B75C565-5BB0- 4DCE-8DE6-67CB7B4F25A7
         * 
         * @param keyRef
         */
        public void setKeyRef(String keyRef) {
            this.keyRef = keyRef;
        }

        /** 
         * Get the 'Owner' attribute value. Owner Airline (or other entity) Code. Examples: BA, WIDGETCO
         * 
         * @return value
         */
        public String getOwner() {
            return owner;
        }

        /** 
         * Set the 'Owner' attribute value. Owner Airline (or other entity) Code. Examples: BA, WIDGETCO
         * 
         * @param owner
         */
        public void setOwner(String owner) {
            this.owner = owner;
        }

        /** 
         * Get the 'Seq' attribute value. Sequence ID. Example: 1
         * 
         * @return value
         */
        public BigInteger getSeq() {
            return seq;
        }

        /** 
         * Set the 'Seq' attribute value. Sequence ID. Example: 1
         * 
         * @param seq
         */
        public void setSeq(BigInteger seq) {
            this.seq = seq;
        }
    }
}
