
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Pre-established Account information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AuthAccountType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AccountID"/>
 *     &lt;xs:element type="xs:string" name="AccountName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FirstName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LastName" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AuthAccountType implements Serializable
{
    private String accountID;
    private String accountName;
    private String firstName;
    private String lastName;

    /** 
     * Get the 'AccountID' element value. Account ID. Examples: FQTV1234, jsmith@email.com
     * 
     * @return value
     */
    public String getAccountID() {
        return accountID;
    }

    /** 
     * Set the 'AccountID' element value. Account ID. Examples: FQTV1234, jsmith@email.com
     * 
     * @param accountID
     */
    public void setAccountID(String accountID) {
        this.accountID = accountID;
    }

    /** 
     * Get the 'AccountName' element value. Pre-established Account Name. Example: johns
     * 
     * @return value
     */
    public String getAccountName() {
        return accountName;
    }

    /** 
     * Set the 'AccountName' element value. Pre-established Account Name. Example: johns
     * 
     * @param accountName
     */
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    /** 
     * Get the 'FirstName' element value. First Name on Account. Example: John
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. First Name on Account. Example: John
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'LastName' element value. Last Name on Account. Example: Smith
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. Last Name on Account. Example: Smith
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
}
