
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Baggage Applicable To contextual list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagAppListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Party"/>
 *     &lt;xs:enumeration value="Traveler"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum BagAppListType implements Serializable {
    PARTY("Party"), TRAVELER("Traveler"), OTHER("Other");
    private final String value;

    private BagAppListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static BagAppListType convert(String value) {
        for (BagAppListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
