
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Baggage Dimension contextual list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagDimensionListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Length"/>
 *     &lt;xs:enumeration value="Height"/>
 *     &lt;xs:enumeration value="Width"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum BagDimensionListType implements Serializable {
    LENGTH("Length"), HEIGHT("Height"), WIDTH("Width");
    private final String value;

    private BagDimensionListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static BagDimensionListType convert(String value) {
        for (BagDimensionListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
