
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Baggage-related Metadata, including Checked Bag, Carry-on Baggage, Baggage Disclosure, Baggage Detail and Baggage Query.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Baggage">
 *   &lt;xs:complexType>
 *     &lt;xs:choice maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class BaggageInner -->
 *     &lt;/xs:choice>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Baggage implements Serializable
{
    private List<BaggageInner> baggageList = new ArrayList<BaggageInner>();

    /** 
     * Get the list of 'Baggage' element items.
     * 
     * @return list
     */
    public List<BaggageInner> getBaggageList() {
        return baggageList;
    }

    /** 
     * Set the list of 'Baggage' element items.
     * 
     * @param list
     */
    public void setBaggageList(List<BaggageInner> list) {
        baggageList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
     *   &lt;xs:element ref="ns:CheckedBagMetadatas"/>
     *   &lt;xs:element ref="ns:CarryOnBagMetadatas"/>
     *   &lt;xs:element ref="ns:BaggageDisclosureMetadatas"/>
     *   &lt;xs:element ref="ns:BaggageDetailMetadata"/>
     *   &lt;xs:element ref="ns:BaggageQueryMetadata"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class BaggageInner implements Serializable
    {
        private int baggageListSelect = -1;
        private static final int CHECKED_BAG_METADATAS_CHOICE = 0;
        private static final int CARRY_ON_BAG_METADATAS_CHOICE = 1;
        private static final int BAGGAGE_DISCLOSURE_METADATAS_CHOICE = 2;
        private static final int BAGGAGE_DETAIL_METADATA_CHOICE = 3;
        private static final int BAGGAGE_QUERY_METADATA_CHOICE = 4;
        private CheckedBagMetadatas checkedBagMetadatas;
        private CarryOnBagMetadatas carryOnBagMetadatas;
        private BaggageDisclosureMetadatas baggageDisclosureMetadatas;
        private BaggageDetailMetadataType baggageDetailMetadata;
        private BaggageQueryMetadataType baggageQueryMetadata;

        private void setBaggageListSelect(int choice) {
            if (baggageListSelect == -1) {
                baggageListSelect = choice;
            } else if (baggageListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearBaggageListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearBaggageListSelect() {
            baggageListSelect = -1;
        }

        /** 
         * Check if CheckedBagMetadatas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCheckedBagMetadatas() {
            return baggageListSelect == CHECKED_BAG_METADATAS_CHOICE;
        }

        /** 
         * Get the 'CheckedBagMetadatas' element value.
         * 
         * @return value
         */
        public CheckedBagMetadatas getCheckedBagMetadatas() {
            return checkedBagMetadatas;
        }

        /** 
         * Set the 'CheckedBagMetadatas' element value.
         * 
         * @param checkedBagMetadatas
         */
        public void setCheckedBagMetadatas(
                CheckedBagMetadatas checkedBagMetadatas) {
            setBaggageListSelect(CHECKED_BAG_METADATAS_CHOICE);
            this.checkedBagMetadatas = checkedBagMetadatas;
        }

        /** 
         * Check if CarryOnBagMetadatas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCarryOnBagMetadatas() {
            return baggageListSelect == CARRY_ON_BAG_METADATAS_CHOICE;
        }

        /** 
         * Get the 'CarryOnBagMetadatas' element value.
         * 
         * @return value
         */
        public CarryOnBagMetadatas getCarryOnBagMetadatas() {
            return carryOnBagMetadatas;
        }

        /** 
         * Set the 'CarryOnBagMetadatas' element value.
         * 
         * @param carryOnBagMetadatas
         */
        public void setCarryOnBagMetadatas(
                CarryOnBagMetadatas carryOnBagMetadatas) {
            setBaggageListSelect(CARRY_ON_BAG_METADATAS_CHOICE);
            this.carryOnBagMetadatas = carryOnBagMetadatas;
        }

        /** 
         * Check if BaggageDisclosureMetadatas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifBaggageDisclosureMetadatas() {
            return baggageListSelect == BAGGAGE_DISCLOSURE_METADATAS_CHOICE;
        }

        /** 
         * Get the 'BaggageDisclosureMetadatas' element value.
         * 
         * @return value
         */
        public BaggageDisclosureMetadatas getBaggageDisclosureMetadatas() {
            return baggageDisclosureMetadatas;
        }

        /** 
         * Set the 'BaggageDisclosureMetadatas' element value.
         * 
         * @param baggageDisclosureMetadatas
         */
        public void setBaggageDisclosureMetadatas(
                BaggageDisclosureMetadatas baggageDisclosureMetadatas) {
            setBaggageListSelect(BAGGAGE_DISCLOSURE_METADATAS_CHOICE);
            this.baggageDisclosureMetadatas = baggageDisclosureMetadatas;
        }

        /** 
         * Check if BaggageDetailMetadata is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifBaggageDetailMetadata() {
            return baggageListSelect == BAGGAGE_DETAIL_METADATA_CHOICE;
        }

        /** 
         * Get the 'BaggageDetailMetadata' element value.
         * 
         * @return value
         */
        public BaggageDetailMetadataType getBaggageDetailMetadata() {
            return baggageDetailMetadata;
        }

        /** 
         * Set the 'BaggageDetailMetadata' element value.
         * 
         * @param baggageDetailMetadata
         */
        public void setBaggageDetailMetadata(
                BaggageDetailMetadataType baggageDetailMetadata) {
            setBaggageListSelect(BAGGAGE_DETAIL_METADATA_CHOICE);
            this.baggageDetailMetadata = baggageDetailMetadata;
        }

        /** 
         * Check if BaggageQueryMetadata is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifBaggageQueryMetadata() {
            return baggageListSelect == BAGGAGE_QUERY_METADATA_CHOICE;
        }

        /** 
         * Get the 'BaggageQueryMetadata' element value.
         * 
         * @return value
         */
        public BaggageQueryMetadataType getBaggageQueryMetadata() {
            return baggageQueryMetadata;
        }

        /** 
         * Set the 'BaggageQueryMetadata' element value.
         * 
         * @param baggageQueryMetadata
         */
        public void setBaggageQueryMetadata(
                BaggageQueryMetadataType baggageQueryMetadata) {
            setBaggageListSelect(BAGGAGE_QUERY_METADATA_CHOICE);
            this.baggageQueryMetadata = baggageQueryMetadata;
        }
    }
}
