
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * BAGGAGE QUERY Metadata definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageQueryMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Ownership" minOccurs="0">
 *           &lt;!-- Reference to inner class Ownership -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="TicketIssuePlace" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="TicketIssueCountry" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="TravelerCount" minOccurs="0"/>
 *         &lt;xs:element type="ns:CurrencyAmountOptType" name="TotalPrice" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageQueryMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private Ownership ownership;
    private String ticketIssuePlace;
    private String ticketIssueCountry;
    private String travelerCount;
    private CurrencyAmountOptType totalPrice;

    /** 
     * Get the 'Ownership' element value.
     * 
     * @return value
     */
    public Ownership getOwnership() {
        return ownership;
    }

    /** 
     * Set the 'Ownership' element value.
     * 
     * @param ownership
     */
    public void setOwnership(Ownership ownership) {
        this.ownership = ownership;
    }

    /** 
     * Get the 'TicketIssuePlace' element value. Ticket issue location.
    Example: MIAFor maximum interoperability, it is recommended that IATA (three character) Airport/ City Code values be used. Use an IATA code or a proprietary string value.
    http://www.iata.org/publications/Pages/code-search.aspx
     * 
     * @return value
     */
    public String getTicketIssuePlace() {
        return ticketIssuePlace;
    }

    /** 
     * Set the 'TicketIssuePlace' element value. Ticket issue location.
    Example: MIAFor maximum interoperability, it is recommended that IATA (three character) Airport/ City Code values be used. Use an IATA code or a proprietary string value.
    http://www.iata.org/publications/Pages/code-search.aspx
     * 
     * @param ticketIssuePlace
     */
    public void setTicketIssuePlace(String ticketIssuePlace) {
        this.ticketIssuePlace = ticketIssuePlace;
    }

    /** 
     * Get the 'TicketIssueCountry' element value. Ticket issue country.
    Example: CA
     * 
     * @return value
     */
    public String getTicketIssueCountry() {
        return ticketIssueCountry;
    }

    /** 
     * Set the 'TicketIssueCountry' element value. Ticket issue country.
    Example: CA
     * 
     * @param ticketIssueCountry
     */
    public void setTicketIssueCountry(String ticketIssueCountry) {
        this.ticketIssueCountry = ticketIssueCountry;
    }

    /** 
     * Get the 'TravelerCount' element value. Total number of passengers of all types for the entire itinerary. Example: 4
     * 
     * @return value
     */
    public String getTravelerCount() {
        return travelerCount;
    }

    /** 
     * Set the 'TravelerCount' element value. Total number of passengers of all types for the entire itinerary. Example: 4
     * 
     * @param travelerCount
     */
    public void setTravelerCount(String travelerCount) {
        this.travelerCount = travelerCount;
    }

    /** 
     * Get the 'TotalPrice' element value. Total price for the entire itinerary for all passengers of all types. Example: 320000
     * 
     * @return value
     */
    public CurrencyAmountOptType getTotalPrice() {
        return totalPrice;
    }

    /** 
     * Set the 'TotalPrice' element value. Total price for the entire itinerary for all passengers of all types. Example: 320000
     * 
     * @param totalPrice
     */
    public void setTotalPrice(CurrencyAmountOptType totalPrice) {
        this.totalPrice = totalPrice;
    }
    /** 
     * PNR ownership.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ownership" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="CRSID" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="GDS" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Ownership implements Serializable
    {
        private String CRSID;
        private String GDS;

        /** 
         * Get the 'CRSID' element value. CRS or carrier department code. Example: BA
         * 
         * @return value
         */
        public String getCRSID() {
            return CRSID;
        }

        /** 
         * Set the 'CRSID' element value. CRS or carrier department code. Example: BA
         * 
         * @param CRSID
         */
        public void setCRSID(String CRSID) {
            this.CRSID = CRSID;
        }

        /** 
         * Get the 'GDS' element value. Ticket issuing aggregator or agency. Example: AMADEUS
         * 
         * @return value
         */
        public String getGDS() {
            return GDS;
        }

        /** 
         * Set the 'GDS' element value. Ticket issuing aggregator or agency. Example: AMADEUS
         * 
         * @param GDS
         */
        public void setGDS(String GDS) {
            this.GDS = GDS;
        }
    }
}
