
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Media Content Seat Camera Position information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinCameraPosType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Row">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="xs:string" name="Position"/>
 *           &lt;xs:element type="ns:CodesetType" name="Orientation" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="Column">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="xs:string" name="Position"/>
 *           &lt;xs:element type="ns:CodesetType" name="Orientation" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CabinCameraPosType implements Serializable
{
    private String rowPosition;
    private CodesetType rowOrientation;
    private String columnPosition;
    private CodesetType columnOrientation;

    /** 
     * Get the 'Position' element value. Row number value.
    Example: 11
     * 
     * @return value
     */
    public String getRowPosition() {
        return rowPosition;
    }

    /** 
     * Set the 'Position' element value. Row number value.
    Example: 11
     * 
     * @param rowPosition
     */
    public void setRowPosition(String rowPosition) {
        this.rowPosition = rowPosition;
    }

    /** 
     * Get the 'Orientation' element value. Icon placement (in orientation to cabin row or column).

    Examples:
    FRO (Place icon before row)
    INL (Place icon inline with row or column)
    LEF (Place icon left of column)
    REA (Place icon behind row)
    RIG (Place icon right of column)

    Encoding Scheme: IATA PADIS code list COT - Camera Orientation Type
     * 
     * @return value
     */
    public CodesetType getRowOrientation() {
        return rowOrientation;
    }

    /** 
     * Set the 'Orientation' element value. Icon placement (in orientation to cabin row or column).

    Examples:
    FRO (Place icon before row)
    INL (Place icon inline with row or column)
    LEF (Place icon left of column)
    REA (Place icon behind row)
    RIG (Place icon right of column)

    Encoding Scheme: IATA PADIS code list COT - Camera Orientation Type
     * 
     * @param rowOrientation
     */
    public void setRowOrientation(CodesetType rowOrientation) {
        this.rowOrientation = rowOrientation;
    }

    /** 
     * Get the 'Position' element value. Column position value.
    Example: C
     * 
     * @return value
     */
    public String getColumnPosition() {
        return columnPosition;
    }

    /** 
     * Set the 'Position' element value. Column position value.
    Example: C
     * 
     * @param columnPosition
     */
    public void setColumnPosition(String columnPosition) {
        this.columnPosition = columnPosition;
    }

    /** 
     * Get the 'Orientation' element value. Icon placement (in orientation to cabin row or column).

    Examples:
    FRO (Place icon before row)
    INL (Place icon inline with row or column)
    LEF (Place icon left of column)
    REA (Place icon behind row)
    RIG (Place icon right of column)

    Encoding Scheme: IATA PADIS code list COT - Camera Orientation Type
     * 
     * @return value
     */
    public CodesetType getColumnOrientation() {
        return columnOrientation;
    }

    /** 
     * Set the 'Orientation' element value. Icon placement (in orientation to cabin row or column).

    Examples:
    FRO (Place icon before row)
    INL (Place icon inline with row or column)
    LEF (Place icon left of column)
    REA (Place icon behind row)
    RIG (Place icon right of column)

    Encoding Scheme: IATA PADIS code list COT - Camera Orientation Type
     * 
     * @param columnOrientation
     */
    public void setColumnOrientation(CodesetType columnOrientation) {
        this.columnOrientation = columnOrientation;
    }
}
