
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Urchin Tracking Monitor(UTM) Parameter definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CampaignUTM_ParameterType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Other_UTM" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class OtherUTM -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CampaignUTMParameterType implements Serializable
{
    private List<OtherUTM> otherUTMList = new ArrayList<OtherUTM>();

    /** 
     * Get the list of 'Other_UTM' element items.
     * 
     * @return list
     */
    public List<OtherUTM> getOtherUTMList() {
        return otherUTMList;
    }

    /** 
     * Set the list of 'Other_UTM' element items.
     * 
     * @param list
     */
    public void setOtherUTMList(List<OtherUTM> list) {
        otherUTMList = list;
    }
    /** 
     * UTM Parameter detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Other_UTM" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="Name"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Definition"/>
     *     &lt;xs:attribute type="ns:UTM_AppListType" use="optional" name="Method"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OtherUTM implements Serializable
    {
        private String name;
        private String value;
        private String definition;
        private UTMAppListType method;

        /** 
         * Get the 'Name' attribute value. UTM Parameter Name. Example: gclid
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' attribute value. UTM Parameter Name. Example: gclid
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'Value' attribute value. UTM Parameter Value. Example: ?gclid=123xyz
         * 
         * @return value
         */
        public String getValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value. UTM Parameter Value. Example: ?gclid=123xyz
         * 
         * @param value
         */
        public void setValue(String value) {
            this.value = value;
        }

        /** 
         * Get the 'Definition' attribute value. 
                    UTM Parameter Name Definition. Example: Google Adwords Destination URL Auto-Tagging Parameter
                  
         * 
         * @return value
         */
        public String getDefinition() {
            return definition;
        }

        /** 
         * Set the 'Definition' attribute value. 
                    UTM Parameter Name Definition. Example: Google Adwords Destination URL Auto-Tagging Parameter
                  
         * 
         * @param definition
         */
        public void setDefinition(String definition) {
            this.definition = definition;
        }

        /** 
         * Get the 'Method' attribute value. 
                    UTM Parameter Role or Method. Examples: Campaign, Medium, Source
                  
         * 
         * @return value
         */
        public UTMAppListType getMethod() {
            return method;
        }

        /** 
         * Set the 'Method' attribute value. 
                    UTM Parameter Role or Method. Examples: Campaign, Medium, Source
                  
         * 
         * @param method
         */
        public void setMethod(UTMAppListType method) {
            this.method = method;
        }
    }
}
