
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Credit Card Qualifier.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardQualifierType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Type"/>
 *         &lt;xs:element type="xs:string" name="IIN_Number" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CardQualifierType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private String type;
    private String IINNumber;

    /** 
     * Get the 'Type' element value. The two letter payment card type. Examples: MC, VI
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. The two letter payment card type. Examples: MC, VI
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'IIN_Number' element value. Payment card IIN/ BIN number. Example: 401123

    Note: This is the first 6 digits of a credit card number known as the Issuer Identification Number (IIN), previously known as bank identification number (BIN), that identifies the institution that issued the card to the card holder.
     * 
     * @return value
     */
    public String getIINNumber() {
        return IINNumber;
    }

    /** 
     * Set the 'IIN_Number' element value. Payment card IIN/ BIN number. Example: 401123

    Note: This is the first 6 digits of a credit card number known as the Issuer Identification Number (IIN), previously known as bank identification number (BIN), that identifies the institution that issued the card to the card holder.
     * 
     * @param IINNumber
     */
    public void setIINNumber(String IINNumber) {
        this.IINNumber = IINNumber;
    }
}
