
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * CHECKED BAG ALLOWANCE defiition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckedBagAllowanceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="CheckedBag" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class CheckedBag -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CheckedBagAllowanceType implements Serializable
{
    private List<CheckedBag> checkedBagList = new ArrayList<CheckedBag>();

    /** 
     * Get the list of 'CheckedBag' element items.
     * 
     * @return list
     */
    public List<CheckedBag> getCheckedBagList() {
        return checkedBagList;
    }

    /** 
     * Set the list of 'CheckedBag' element items.
     * 
     * @param list
     */
    public void setCheckedBagList(List<CheckedBag> list) {
        checkedBagList = list;
    }
    /** 
     * Checked Bag Allowance detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckedBag" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:WeightAllowance" minOccurs="0"/>
     *           &lt;xs:element ref="ns:PieceAllowance" minOccurs="0" maxOccurs="unbounded"/>
     *           &lt;xs:element ref="ns:DimensionAllowance" minOccurs="0"/>
     *           &lt;xs:element ref="ns:AllowanceDescription" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CheckedBag extends KeyWithMetaObjectBaseType implements
        Serializable
    {
        private WeightAllowance weightAllowance;
        private List<BagAllowancePieceType> pieceAllowanceList = new ArrayList<BagAllowancePieceType>();
        private BagAllowanceDimensionType dimensionAllowance;
        private BagAllowanceDescType allowanceDescription;

        /** 
         * Get the 'WeightAllowance' element value.
         * 
         * @return value
         */
        public WeightAllowance getWeightAllowance() {
            return weightAllowance;
        }

        /** 
         * Set the 'WeightAllowance' element value.
         * 
         * @param weightAllowance
         */
        public void setWeightAllowance(WeightAllowance weightAllowance) {
            this.weightAllowance = weightAllowance;
        }

        /** 
         * Get the list of 'PieceAllowance' element items. Defines the maximum number of each allowable baggage type.
         * 
         * @return list
         */
        public List<BagAllowancePieceType> getPieceAllowanceList() {
            return pieceAllowanceList;
        }

        /** 
         * Set the list of 'PieceAllowance' element items. Defines the maximum number of each allowable baggage type.
         * 
         * @param list
         */
        public void setPieceAllowanceList(List<BagAllowancePieceType> list) {
            pieceAllowanceList = list;
        }

        /** 
         * Get the 'DimensionAllowance' element value.
         * 
         * @return value
         */
        public BagAllowanceDimensionType getDimensionAllowance() {
            return dimensionAllowance;
        }

        /** 
         * Set the 'DimensionAllowance' element value.
         * 
         * @param dimensionAllowance
         */
        public void setDimensionAllowance(
                BagAllowanceDimensionType dimensionAllowance) {
            this.dimensionAllowance = dimensionAllowance;
        }

        /** 
         * Get the 'AllowanceDescription' element value.
         * 
         * @return value
         */
        public BagAllowanceDescType getAllowanceDescription() {
            return allowanceDescription;
        }

        /** 
         * Set the 'AllowanceDescription' element value.
         * 
         * @param allowanceDescription
         */
        public void setAllowanceDescription(
                BagAllowanceDescType allowanceDescription) {
            this.allowanceDescription = allowanceDescription;
        }
    }
}
