
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Cheque Payment
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cheque">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="xs:int" name="Number" minOccurs="0"/>
 *       &lt;xs:element type="xs:date" name="SignedDate" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="OrderTo" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Cheque implements Serializable
{
    private Integer number;
    private Date signedDate;
    private String orderTo;

    /** 
     * Get the 'Number' element value. Cheque number
     * 
     * @return value
     */
    public Integer getNumber() {
        return number;
    }

    /** 
     * Set the 'Number' element value. Cheque number
     * 
     * @param number
     */
    public void setNumber(Integer number) {
        this.number = number;
    }

    /** 
     * Get the 'SignedDate' element value. Cheque signed date
     * 
     * @return value
     */
    public Date getSignedDate() {
        return signedDate;
    }

    /** 
     * Set the 'SignedDate' element value. Cheque signed date
     * 
     * @param signedDate
     */
    public void setSignedDate(Date signedDate) {
        this.signedDate = signedDate;
    }

    /** 
     * Get the 'OrderTo' element value. Name of the Payee
     * 
     * @return value
     */
    public String getOrderTo() {
        return orderTo;
    }

    /** 
     * Set the 'OrderTo' element value. Name of the Payee
     * 
     * @param orderTo
     */
    public void setOrderTo(String orderTo) {
        this.orderTo = orderTo;
    }
}
