
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A data type for Core Commission.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:choice>
 *           &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
 *           &lt;xs:element type="xs:decimal" name="Percentage"/>
 *         &lt;/xs:choice>
 *         &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CommissionType extends AssociatedObjectBaseType implements
    Serializable
{
    private int choiceSelect = -1;
    private static final int AMOUNT_CHOICE = 0;
    private static final int PERCENTAGE_CHOICE = 1;
    private CurrencyAmountOptType amount;
    private BigDecimal percentage;
    private String code;
    private Remarks remarks;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Amount is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmount() {
        return choiceSelect == AMOUNT_CHOICE;
    }

    /** 
     * Get the 'Amount' element value. Commission amount. Example: 20.00 USD
     * 
     * @return value
     */
    public CurrencyAmountOptType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Commission amount. Example: 20.00 USD
     * 
     * @param amount
     */
    public void setAmount(CurrencyAmountOptType amount) {
        setChoiceSelect(AMOUNT_CHOICE);
        this.amount = amount;
    }

    /** 
     * Check if Percentage is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPercentage() {
        return choiceSelect == PERCENTAGE_CHOICE;
    }

    /** 
     * Get the 'Percentage' element value. Commission percentage. Example: 20
     * 
     * @return value
     */
    public BigDecimal getPercentage() {
        return percentage;
    }

    /** 
     * Set the 'Percentage' element value. Commission percentage. Example: 20
     * 
     * @param percentage
     */
    public void setPercentage(BigDecimal percentage) {
        setChoiceSelect(PERCENTAGE_CHOICE);
        this.percentage = percentage;
    }

    /** 
     * Get the 'Code' element value. Commission code. Example: 1000, BFST
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Commission code. Example: 1000, BFST
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }
}
