
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Coupon Media Type contextual list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponMediaListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Electronic"/>
 *     &lt;xs:enumeration value="Paper"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CouponMediaListType implements Serializable {
    ELECTRONIC("Electronic"), PAPER("Paper"), OTHER("Other");
    private final String value;

    private CouponMediaListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CouponMediaListType convert(String value) {
        for (CouponMediaListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
