
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * COUPON-RELATED Traveler CORE definitiion.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponTravelerCoreType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Surname">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="Given">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="PTC" minOccurs="0"/>
 *     &lt;xs:element type="ns:TravelerFQTV_Type" name="FQTV" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:date" name="BirthDate" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="InfantOnLapInd"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CouponTravelerCoreType implements Serializable
{
    private String surnameString;
    private String surnameRefs;
    private String givenString;
    private String givenRefs;
    private String PTC;
    private List<TravelerFQTVType> FQTVList = new ArrayList<TravelerFQTVType>();
    private Date birthDate;
    private Boolean infantOnLapInd;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getSurnameString() {
        return surnameString;
    }

    /** 
     * Set the extension value.
     * 
     * @param surnameString
     */
    public void setSurnameString(String surnameString) {
        this.surnameString = surnameString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getSurnameRefs() {
        return surnameRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param surnameRefs
     */
    public void setSurnameRefs(String surnameRefs) {
        this.surnameRefs = surnameRefs;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getGivenString() {
        return givenString;
    }

    /** 
     * Set the extension value.
     * 
     * @param givenString
     */
    public void setGivenString(String givenString) {
        this.givenString = givenString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getGivenRefs() {
        return givenRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param givenRefs
     */
    public void setGivenRefs(String givenRefs) {
        this.givenRefs = givenRefs;
    }

    /** 
     * Get the 'PTC' element value. Passenger type code and travelers quantity. 

    Example: ADT

    Encoding Scheme:  IATA (three character) Passenger Type Code
     * 
     * @return value
     */
    public String getPTC() {
        return PTC;
    }

    /** 
     * Set the 'PTC' element value. Passenger type code and travelers quantity. 

    Example: ADT

    Encoding Scheme:  IATA (three character) Passenger Type Code
     * 
     * @param PTC
     */
    public void setPTC(String PTC) {
        this.PTC = PTC;
    }

    /** 
     * Get the list of 'FQTV' element items. Frequent Travel Program information.
     * 
     * @return list
     */
    public List<TravelerFQTVType> getFQTVList() {
        return FQTVList;
    }

    /** 
     * Set the list of 'FQTV' element items. Frequent Travel Program information.
     * 
     * @param list
     */
    public void setFQTVList(List<TravelerFQTVType> list) {
        FQTVList = list;
    }

    /** 
     * Get the 'BirthDate' element value. The date of birth of the traveler
     * 
     * @return value
     */
    public Date getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' element value. The date of birth of the traveler
     * 
     * @param birthDate
     */
    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'InfantOnLapInd' attribute value. When TRUE, this Traveler is an infant on lap that does not require a seat.
     * 
     * @return value
     */
    public Boolean getInfantOnLapInd() {
        return infantOnLapInd;
    }

    /** 
     * Set the 'InfantOnLapInd' attribute value. When TRUE, this Traveler is an infant on lap that does not require a seat.
     * 
     * @param infantOnLapInd
     */
    public void setInfantOnLapInd(Boolean infantOnLapInd) {
        this.infantOnLapInd = infantOnLapInd;
    }
}
