
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * AMOUNT with OPTIONAL CURRENCY ENCODING representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyAmountOptType">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:decimal">
 *       &lt;xs:attributeGroup ref="ns:AmountCurrencyOptGroup"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" default="true" name="Taxable"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AmountCurrencyOptGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CurrencyAmountOptType implements Serializable
{
    private BigDecimal decimal;
    private String code;
    private Boolean taxable;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public BigDecimal getDecimal() {
        return decimal;
    }

    /** 
     * Set the extension value.
     * 
     * @param decimal
     */
    public void setDecimal(BigDecimal decimal) {
        this.decimal = decimal;
    }

    /** 
     * Get the 'Code' attribute value. Currency code. Example: USD
    Encoding Scheme: ISO 4217 (three alpha character) Currency Code
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' attribute value. Currency code. Example: USD
    Encoding Scheme: ISO 4217 (three alpha character) Currency Code
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'Taxable' attribute value. In some markets, commission is VAT-able (ie Taxable)
     * 
     * @return value
     */
    public Boolean getTaxable() {
        return taxable;
    }

    /** 
     * Set the 'Taxable' attribute value. In some markets, commission is VAT-able (ie Taxable)
     * 
     * @param taxable
     */
    public void setTaxable(Boolean taxable) {
        this.taxable = taxable;
    }
}
