
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for CURRENCY Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Decimals" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CurrencyMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private String application;
    private String decimals;
    private String name;

    /** 
     * Get the 'Application' element value. Currency application. Example: Actual Pricing, Display Currency, Requested Pricing
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Currency application. Example: Actual Pricing, Display Currency, Requested Pricing
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'Decimals' element value. Number of decimal places.  Example: 2

    Note: This is used for amount values. For example, if the associated number of decimal places is 2, a currency value of 10000 is equal to 100.00
     * 
     * @return value
     */
    public String getDecimals() {
        return decimals;
    }

    /** 
     * Set the 'Decimals' element value. Number of decimal places.  Example: 2

    Note: This is used for amount values. For example, if the associated number of decimal places is 2, a currency value of 10000 is equal to 100.00
     * 
     * @param decimals
     */
    public void setDecimals(String decimals) {
        this.decimals = decimals;
    }

    /** 
     * Get the 'Name' element value. Currency name.  Example: US Dollars
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Currency name.  Example: US Dollars
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
