
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A base type for a Data List object.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataListObjectBaseType">
 *   &lt;xs:attributeGroup ref="ns:DataListObjAttrGroup"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="DisplayAllInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="NetFareInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ReissueOnlyInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AutoExchangeInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="BundleInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="MaximumTryInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="NotProcessedInd"/>
 *   &lt;xs:attribute type="xs:boolean" name="RetryInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DataListObjectBaseType implements Serializable
{
    private DataListObjAttrGroup dataListObjAttrGroup;
    private Boolean displayAllInd;
    private Boolean netFareInd;
    private Boolean reissueOnlyInd;
    private Boolean autoExchangeInd;
    private Boolean bundleInd;
    private Boolean maximumTryInd;
    private Boolean notProcessedInd;
    private Boolean retryInd;

    /** 
     * Get the 'DataListObjAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public DataListObjAttrGroup getDataListObjAttrGroup() {
        return dataListObjAttrGroup;
    }

    /** 
     * Set the 'DataListObjAttrGroup' attributeGroup value.
     * 
     * @param dataListObjAttrGroup
     */
    public void setDataListObjAttrGroup(
            DataListObjAttrGroup dataListObjAttrGroup) {
        this.dataListObjAttrGroup = dataListObjAttrGroup;
    }

    /** 
     * Get the 'DisplayAllInd' attribute value. When TRUE, all disclosures should be displayed.

    Notes: This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification.
     * 
     * @return value
     */
    public Boolean getDisplayAllInd() {
        return displayAllInd;
    }

    /** 
     * Set the 'DisplayAllInd' attribute value. When TRUE, all disclosures should be displayed.

    Notes: This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification.
     * 
     * @param displayAllInd
     */
    public void setDisplayAllInd(Boolean displayAllInd) {
        this.displayAllInd = displayAllInd;
    }

    /** 
     * Get the 'NetFareInd' attribute value. When TRUE, this is a Cat35 C-Type net fare.
     * 
     * @return value
     */
    public Boolean getNetFareInd() {
        return netFareInd;
    }

    /** 
     * Set the 'NetFareInd' attribute value. When TRUE, this is a Cat35 C-Type net fare.
     * 
     * @param netFareInd
     */
    public void setNetFareInd(Boolean netFareInd) {
        this.netFareInd = netFareInd;
    }

    /** 
     * Get the 'ReissueOnlyInd' attribute value. When TRUE, the Fare was priced to reissue a partially flown ticket.
     * 
     * @return value
     */
    public Boolean getReissueOnlyInd() {
        return reissueOnlyInd;
    }

    /** 
     * Set the 'ReissueOnlyInd' attribute value. When TRUE, the Fare was priced to reissue a partially flown ticket.
     * 
     * @param reissueOnlyInd
     */
    public void setReissueOnlyInd(Boolean reissueOnlyInd) {
        this.reissueOnlyInd = reissueOnlyInd;
    }

    /** 
     * Get the 'AutoExchangeInd' attribute value. When TRUE, this fare has been returned from an auto-exchanging application.
     * 
     * @return value
     */
    public Boolean getAutoExchangeInd() {
        return autoExchangeInd;
    }

    /** 
     * Set the 'AutoExchangeInd' attribute value. When TRUE, this fare has been returned from an auto-exchanging application.
     * 
     * @param autoExchangeInd
     */
    public void setAutoExchangeInd(Boolean autoExchangeInd) {
        this.autoExchangeInd = autoExchangeInd;
    }

    /** 
     * Get the 'BundleInd' attribute value. When TRUE, this service is part of a Service Bundle.

    Note: Associated Service Bundle information is specified in the Bundle node.
     * 
     * @return value
     */
    public Boolean getBundleInd() {
        return bundleInd;
    }

    /** 
     * Set the 'BundleInd' attribute value. When TRUE, this service is part of a Service Bundle.

    Note: Associated Service Bundle information is specified in the Bundle node.
     * 
     * @param bundleInd
     */
    public void setBundleInd(Boolean bundleInd) {
        this.bundleInd = bundleInd;
    }

    /** 
     * Get the 'MaximumTryInd' attribute value. When TRUE, the maximum payment authentication attemps for this payment form have been exceeded.
     * 
     * @return value
     */
    public Boolean getMaximumTryInd() {
        return maximumTryInd;
    }

    /** 
     * Set the 'MaximumTryInd' attribute value. When TRUE, the maximum payment authentication attemps for this payment form have been exceeded.
     * 
     * @param maximumTryInd
     */
    public void setMaximumTryInd(Boolean maximumTryInd) {
        this.maximumTryInd = maximumTryInd;
    }

    /** 
     * Get the 'NotProcessedInd' attribute value. When TRUE, this Payment Form information has not been processed.
     * 
     * @return value
     */
    public Boolean getNotProcessedInd() {
        return notProcessedInd;
    }

    /** 
     * Set the 'NotProcessedInd' attribute value. When TRUE, this Payment Form information has not been processed.
     * 
     * @param notProcessedInd
     */
    public void setNotProcessedInd(Boolean notProcessedInd) {
        this.notProcessedInd = notProcessedInd;
    }

    /** 
     * Get the 'RetryInd' attribute value. When TRUE, this payment form transaction should be resent.
     * 
     * @return value
     */
    public Boolean getRetryInd() {
        return retryInd;
    }

    /** 
     * Set the 'RetryInd' attribute value. When TRUE, this payment form transaction should be resent.
     * 
     * @param retryInd
     */
    public void setRetryInd(Boolean retryInd) {
        this.retryInd = retryInd;
    }
}
