
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Common NDC Data List choices.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataListType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:AnonymousTravelerList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:RecognizedTravelerList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:BagDisclosureList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:CarryOnAllowanceList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:CheckedBagAllowanceList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:ClassOfServiceList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:ContentSourceList" minOccurs="0"/>
 *     &lt;xs:element name="DescriptionList" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="ns:Description"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:DisclosureList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:FareList" minOccurs="0"/>
 *     &lt;xs:element name="FlightSegmentList" minOccurs="0">
 *       &lt;!-- Reference to inner class FlightSegmentList -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FlightList" minOccurs="0">
 *       &lt;!-- Reference to inner class FlightList -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OriginDestinationList" minOccurs="0">
 *       &lt;!-- Reference to inner class OriginDestinationList -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:InstructionsList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:MediaList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:PenaltyList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:PriceClassList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:ServiceBundleList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:ServiceList" minOccurs="0"/>
 *     &lt;xs:element ref="ns:TermsList" minOccurs="0"/>
 *     &lt;xs:element name="SeatList" minOccurs="0">
 *       &lt;!-- Reference to inner class SeatList -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DataListType implements Serializable
{
    private AnonymousTravelerList anonymousTravelerList;
    private RecognizedTravelerList recognizedTravelerList;
    private ListOfBagDisclosureType bagDisclosureList;
    private ListOfCarryOnAllowanceType carryOnAllowanceList;
    private ListOfBagAllowanceType checkedBagAllowanceList;
    private ListOfClassOfServiceType classOfServiceList;
    private ListOfContentSourceType contentSourceList;
    private Description descriptionList;
    private ListOfDisclosureType disclosureList;
    private FareList fareList;
    private FlightSegmentList flightSegmentList;
    private FlightList flightList;
    private OriginDestinationList originDestinationList;
    private ListOfOfferInstructionsType instructionsList;
    private ListOfMediaType mediaList;
    private ListOfOfferPenaltyType penaltyList;
    private ListOfPriceClassType priceClassList;
    private ListOfServiceBundleType serviceBundleList;
    private ServiceList serviceList;
    private ListOfOfferTermsType termsList;
    private SeatList seatList;

    /** 
     * Get the 'AnonymousTravelerList' element value.
     * 
     * @return value
     */
    public AnonymousTravelerList getAnonymousTravelerList() {
        return anonymousTravelerList;
    }

    /** 
     * Set the 'AnonymousTravelerList' element value.
     * 
     * @param anonymousTravelerList
     */
    public void setAnonymousTravelerList(
            AnonymousTravelerList anonymousTravelerList) {
        this.anonymousTravelerList = anonymousTravelerList;
    }

    /** 
     * Get the 'RecognizedTravelerList' element value.
     * 
     * @return value
     */
    public RecognizedTravelerList getRecognizedTravelerList() {
        return recognizedTravelerList;
    }

    /** 
     * Set the 'RecognizedTravelerList' element value.
     * 
     * @param recognizedTravelerList
     */
    public void setRecognizedTravelerList(
            RecognizedTravelerList recognizedTravelerList) {
        this.recognizedTravelerList = recognizedTravelerList;
    }

    /** 
     * Get the 'BagDisclosureList' element value.
     * 
     * @return value
     */
    public ListOfBagDisclosureType getBagDisclosureList() {
        return bagDisclosureList;
    }

    /** 
     * Set the 'BagDisclosureList' element value.
     * 
     * @param bagDisclosureList
     */
    public void setBagDisclosureList(ListOfBagDisclosureType bagDisclosureList) {
        this.bagDisclosureList = bagDisclosureList;
    }

    /** 
     * Get the 'CarryOnAllowanceList' element value.
     * 
     * @return value
     */
    public ListOfCarryOnAllowanceType getCarryOnAllowanceList() {
        return carryOnAllowanceList;
    }

    /** 
     * Set the 'CarryOnAllowanceList' element value.
     * 
     * @param carryOnAllowanceList
     */
    public void setCarryOnAllowanceList(
            ListOfCarryOnAllowanceType carryOnAllowanceList) {
        this.carryOnAllowanceList = carryOnAllowanceList;
    }

    /** 
     * Get the 'CheckedBagAllowanceList' element value.
     * 
     * @return value
     */
    public ListOfBagAllowanceType getCheckedBagAllowanceList() {
        return checkedBagAllowanceList;
    }

    /** 
     * Set the 'CheckedBagAllowanceList' element value.
     * 
     * @param checkedBagAllowanceList
     */
    public void setCheckedBagAllowanceList(
            ListOfBagAllowanceType checkedBagAllowanceList) {
        this.checkedBagAllowanceList = checkedBagAllowanceList;
    }

    /** 
     * Get the 'ClassOfServiceList' element value.
     * 
     * @return value
     */
    public ListOfClassOfServiceType getClassOfServiceList() {
        return classOfServiceList;
    }

    /** 
     * Set the 'ClassOfServiceList' element value.
     * 
     * @param classOfServiceList
     */
    public void setClassOfServiceList(
            ListOfClassOfServiceType classOfServiceList) {
        this.classOfServiceList = classOfServiceList;
    }

    /** 
     * Get the 'ContentSourceList' element value.
     * 
     * @return value
     */
    public ListOfContentSourceType getContentSourceList() {
        return contentSourceList;
    }

    /** 
     * Set the 'ContentSourceList' element value.
     * 
     * @param contentSourceList
     */
    public void setContentSourceList(ListOfContentSourceType contentSourceList) {
        this.contentSourceList = contentSourceList;
    }

    /** 
     * Get the 'Description' element value. Description Details
     * 
     * @return value
     */
    public Description getDescriptionList() {
        return descriptionList;
    }

    /** 
     * Set the 'Description' element value. Description Details
     * 
     * @param descriptionList
     */
    public void setDescriptionList(Description descriptionList) {
        this.descriptionList = descriptionList;
    }

    /** 
     * Get the 'DisclosureList' element value.
     * 
     * @return value
     */
    public ListOfDisclosureType getDisclosureList() {
        return disclosureList;
    }

    /** 
     * Set the 'DisclosureList' element value.
     * 
     * @param disclosureList
     */
    public void setDisclosureList(ListOfDisclosureType disclosureList) {
        this.disclosureList = disclosureList;
    }

    /** 
     * Get the 'FareList' element value.
     * 
     * @return value
     */
    public FareList getFareList() {
        return fareList;
    }

    /** 
     * Set the 'FareList' element value.
     * 
     * @param fareList
     */
    public void setFareList(FareList fareList) {
        this.fareList = fareList;
    }

    /** 
     * Get the 'FlightSegmentList' element value.
     * 
     * @return value
     */
    public FlightSegmentList getFlightSegmentList() {
        return flightSegmentList;
    }

    /** 
     * Set the 'FlightSegmentList' element value.
     * 
     * @param flightSegmentList
     */
    public void setFlightSegmentList(FlightSegmentList flightSegmentList) {
        this.flightSegmentList = flightSegmentList;
    }

    /** 
     * Get the 'FlightList' element value.
     * 
     * @return value
     */
    public FlightList getFlightList() {
        return flightList;
    }

    /** 
     * Set the 'FlightList' element value.
     * 
     * @param flightList
     */
    public void setFlightList(FlightList flightList) {
        this.flightList = flightList;
    }

    /** 
     * Get the 'OriginDestinationList' element value.
     * 
     * @return value
     */
    public OriginDestinationList getOriginDestinationList() {
        return originDestinationList;
    }

    /** 
     * Set the 'OriginDestinationList' element value.
     * 
     * @param originDestinationList
     */
    public void setOriginDestinationList(
            OriginDestinationList originDestinationList) {
        this.originDestinationList = originDestinationList;
    }

    /** 
     * Get the 'InstructionsList' element value.
     * 
     * @return value
     */
    public ListOfOfferInstructionsType getInstructionsList() {
        return instructionsList;
    }

    /** 
     * Set the 'InstructionsList' element value.
     * 
     * @param instructionsList
     */
    public void setInstructionsList(ListOfOfferInstructionsType instructionsList) {
        this.instructionsList = instructionsList;
    }

    /** 
     * Get the 'MediaList' element value.
     * 
     * @return value
     */
    public ListOfMediaType getMediaList() {
        return mediaList;
    }

    /** 
     * Set the 'MediaList' element value.
     * 
     * @param mediaList
     */
    public void setMediaList(ListOfMediaType mediaList) {
        this.mediaList = mediaList;
    }

    /** 
     * Get the 'PenaltyList' element value.
     * 
     * @return value
     */
    public ListOfOfferPenaltyType getPenaltyList() {
        return penaltyList;
    }

    /** 
     * Set the 'PenaltyList' element value.
     * 
     * @param penaltyList
     */
    public void setPenaltyList(ListOfOfferPenaltyType penaltyList) {
        this.penaltyList = penaltyList;
    }

    /** 
     * Get the 'PriceClassList' element value.
     * 
     * @return value
     */
    public ListOfPriceClassType getPriceClassList() {
        return priceClassList;
    }

    /** 
     * Set the 'PriceClassList' element value.
     * 
     * @param priceClassList
     */
    public void setPriceClassList(ListOfPriceClassType priceClassList) {
        this.priceClassList = priceClassList;
    }

    /** 
     * Get the 'ServiceBundleList' element value.
     * 
     * @return value
     */
    public ListOfServiceBundleType getServiceBundleList() {
        return serviceBundleList;
    }

    /** 
     * Set the 'ServiceBundleList' element value.
     * 
     * @param serviceBundleList
     */
    public void setServiceBundleList(ListOfServiceBundleType serviceBundleList) {
        this.serviceBundleList = serviceBundleList;
    }

    /** 
     * Get the 'ServiceList' element value.
     * 
     * @return value
     */
    public ServiceList getServiceList() {
        return serviceList;
    }

    /** 
     * Set the 'ServiceList' element value.
     * 
     * @param serviceList
     */
    public void setServiceList(ServiceList serviceList) {
        this.serviceList = serviceList;
    }

    /** 
     * Get the 'TermsList' element value.
     * 
     * @return value
     */
    public ListOfOfferTermsType getTermsList() {
        return termsList;
    }

    /** 
     * Set the 'TermsList' element value.
     * 
     * @param termsList
     */
    public void setTermsList(ListOfOfferTermsType termsList) {
        this.termsList = termsList;
    }

    /** 
     * Get the 'SeatList' element value.
     * 
     * @return value
     */
    public SeatList getSeatList() {
        return seatList;
    }

    /** 
     * Set the 'SeatList' element value.
     * 
     * @param seatList
     */
    public void setSeatList(SeatList seatList) {
        this.seatList = seatList;
    }
    /** 
     * List of flight segments.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegmentList" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:ListOfFlightSegmentType" name="FlightSegment" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightSegmentList implements Serializable
    {
        private List<ListOfFlightSegmentType> flightSegmentList = new ArrayList<ListOfFlightSegmentType>();

        /** 
         * Get the list of 'FlightSegment' element items. FlighSegment information. Contains details flight segment information.
         * 
         * @return list
         */
        public List<ListOfFlightSegmentType> getFlightSegmentList() {
            return flightSegmentList;
        }

        /** 
         * Set the list of 'FlightSegment' element items. FlighSegment information. Contains details flight segment information.
         * 
         * @param list
         */
        public void setFlightSegmentList(List<ListOfFlightSegmentType> list) {
            flightSegmentList = list;
        }
    }
    /** 
     * List of Flight elements.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightList" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Flight" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Flight -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightList implements Serializable
    {
        private List<Flight> flightList = new ArrayList<Flight>();

        /** 
         * Get the list of 'Flight' element items.
         * 
         * @return list
         */
        public List<Flight> getFlightList() {
            return flightList;
        }

        /** 
         * Set the list of 'Flight' element items.
         * 
         * @param list
         */
        public void setFlightList(List<Flight> list) {
            flightList = list;
        }
        /** 
         * Journey information describing the travel between an airport/city where travel commences and an airport/city where travel ultimately terminates. A journey may be comprised of one or more segments. Note: This node will be renamed to journey in future releases.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:TotalJourneyType" name="Journey" minOccurs="0"/>
         *       &lt;xs:element ref="ns:SegmentReferences"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *     &lt;xs:attribute type="xs:string" name="FlightKey"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Flight implements Serializable
        {
            private TotalJourneyType journey;
            private SegmentReferences segmentReferences;
            private String refs;
            private String flightKey;

            /** 
             * Get the 'Journey' element value. Flight journey information.
             * 
             * @return value
             */
            public TotalJourneyType getJourney() {
                return journey;
            }

            /** 
             * Set the 'Journey' element value. Flight journey information.
             * 
             * @param journey
             */
            public void setJourney(TotalJourneyType journey) {
                this.journey = journey;
            }

            /** 
             * Get the 'SegmentReferences' element value.
             * 
             * @return value
             */
            public SegmentReferences getSegmentReferences() {
                return segmentReferences;
            }

            /** 
             * Set the 'SegmentReferences' element value.
             * 
             * @param segmentReferences
             */
            public void setSegmentReferences(SegmentReferences segmentReferences) {
                this.segmentReferences = segmentReferences;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }

            /** 
             * Get the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
             * 
             * @return value
             */
            public String getFlightKey() {
                return flightKey;
            }

            /** 
             * Set the 'FlightKey' attribute value. A globally unique identifier for this Flight instance. Example: flight1
             * 
             * @param flightKey
             */
            public void setFlightKey(String flightKey) {
                this.flightKey = flightKey;
            }
        }
    }
    /** 
     * List of Origin/Destination elements.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationList" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:OriginDestination" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationList implements Serializable
    {
        private List<OriginDestination> originDestinationList = new ArrayList<OriginDestination>();

        /** 
         * Get the list of 'OriginDestination' element items.
         * 
         * @return list
         */
        public List<OriginDestination> getOriginDestinationList() {
            return originDestinationList;
        }

        /** 
         * Set the list of 'OriginDestination' element items.
         * 
         * @param list
         */
        public void setOriginDestinationList(List<OriginDestination> list) {
            originDestinationList = list;
        }
    }
    /** 
     * Optional Seat(s) List.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatList" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:ListOfSeatType" name="Seats" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SeatList implements Serializable
    {
        private List<ListOfSeatType> seatList = new ArrayList<ListOfSeatType>();

        /** 
         * Get the list of 'Seats' element items. Seat Detail.
         * 
         * @return list
         */
        public List<ListOfSeatType> getSeatList() {
            return seatList;
        }

        /** 
         * Set the list of 'Seats' element items. Seat Detail.
         * 
         * @param list
         */
        public void setSeatList(List<ListOfSeatType> list) {
            seatList = list;
        }
    }
}
