
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Device identification.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeviceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Type" minOccurs="0">
 *       &lt;!-- Reference to inner class Type -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:PhoneNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="IP_Address" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MAC_Address" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeviceType implements Serializable
{
    private Type type;
    private PhoneNumber phoneNumber;
    private String IPAddress;
    private String MACAddress;
    private String name;

    /** 
     * Get the 'Type' element value.
     * 
     * @return value
     */
    public Type getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value.
     * 
     * @param type
     */
    public void setType(Type type) {
        this.type = type;
    }

    /** 
     * Get the 'PhoneNumber' element value. Provides telephone information, and allows to specify telephone number application (ie Home, Business, etc.). May be used for a simle, unstrucutured number, or, in combination with child attributes allows to create a structured telephone number (ie Country Code number, Area Code numbers, etc.)
     * 
     * @return value
     */
    public PhoneNumber getPhoneNumber() {
        return phoneNumber;
    }

    /** 
     * Set the 'PhoneNumber' element value. Provides telephone information, and allows to specify telephone number application (ie Home, Business, etc.). May be used for a simle, unstrucutured number, or, in combination with child attributes allows to create a structured telephone number (ie Country Code number, Area Code numbers, etc.)
     * 
     * @param phoneNumber
     */
    public void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /** 
     * Get the 'IP_Address' element value. Associated IP address.
    Examples: 192.0.2.8, 198.51.100.0
     * 
     * @return value
     */
    public String getIPAddress() {
        return IPAddress;
    }

    /** 
     * Set the 'IP_Address' element value. Associated IP address.
    Examples: 192.0.2.8, 198.51.100.0
     * 
     * @param IPAddress
     */
    public void setIPAddress(String IPAddress) {
        this.IPAddress = IPAddress;
    }

    /** 
     * Get the 'MAC_Address' element value. Device MAC Address. Example: 00:0a:95:9d:68:16
     * 
     * @return value
     */
    public String getMACAddress() {
        return MACAddress;
    }

    /** 
     * Set the 'MAC_Address' element value. Device MAC Address. Example: 00:0a:95:9d:68:16
     * 
     * @param MACAddress
     */
    public void setMACAddress(String MACAddress) {
        this.MACAddress = MACAddress;
    }

    /** 
     * Get the 'Name' element value. Named Device ID. Example: Bonnies iPad
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Named Device ID. Example: Bonnies iPad
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
    /** 
     * Device Type. Examples: Web Browser, Mobile Device

    Encoding Scheme: IATA Padis Codeset - List for data element TDT (Touchpoint Device Type)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Type" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:CodesetType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:Position" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Type extends CodesetType implements Serializable
    {
        private PositionType position;

        /** 
         * Get the 'Position' element value. Device position and geocoding coordinates.
         * 
         * @return value
         */
        public PositionType getPosition() {
            return position;
        }

        /** 
         * Set the 'Position' element value. Device position and geocoding coordinates.
         * 
         * @param position
         */
        public void setPosition(PositionType position) {
            this.position = position;
        }
    }
}
