
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * DIRECTIONS definition.NDC Capability Model: Directions

 1. Representation(s): URL to source; Plain Text
 2. Association(s): Airport, City, x, x and y
 3. Feature(s): From/To Context; Named Collection
 3. Metadata: Yes
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DirectionsType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:choice>
 *           &lt;xs:element type="xs:string" name="Text"/>
 *           &lt;xs:element type="xs:string" name="Link"/>
 *         &lt;/xs:choice>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="From" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="To" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DirectionsType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private int choiceSelect = -1;
    private static final int TEXT_CHOICE = 0;
    private static final int LINK_CHOICE = 1;
    private String text;
    private String link;
    private String name;
    private String from;
    private String to;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Text is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifText() {
        return choiceSelect == TEXT_CHOICE;
    }

    /** 
     * Get the 'Text' element value. Text-based Directions.
     * 
     * @return value
     */
    public String getText() {
        return text;
    }

    /** 
     * Set the 'Text' element value. Text-based Directions.
     * 
     * @param text
     */
    public void setText(String text) {
        setChoiceSelect(TEXT_CHOICE);
        this.text = text;
    }

    /** 
     * Check if Link is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLink() {
        return choiceSelect == LINK_CHOICE;
    }

    /** 
     * Get the 'Link' element value. Directions source URL.
     * 
     * @return value
     */
    public String getLink() {
        return link;
    }

    /** 
     * Set the 'Link' element value. Directions source URL.
     * 
     * @param link
     */
    public void setLink(String link) {
        setChoiceSelect(LINK_CHOICE);
        this.link = link;
    }

    /** 
     * Get the 'Name' element value. Directions name. Example: Directions to Headquarters
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Directions name. Example: Directions to Headquarters
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'From' element value. Directions from location. Example: City Center
     * 
     * @return value
     */
    public String getFrom() {
        return from;
    }

    /** 
     * Set the 'From' element value. Directions from location. Example: City Center
     * 
     * @param from
     */
    public void setFrom(String from) {
        this.from = from;
    }

    /** 
     * Get the 'To' element value. Directions to location. Example: Headquarters
     * 
     * @return value
     */
    public String getTo() {
        return to;
    }

    /** 
     * Set the 'To' element value. Directions to location. Example: Headquarters
     * 
     * @param to
     */
    public void setTo(String to) {
        this.to = to;
    }
}
