
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for a Discount Program Qualifier.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiscountProgramType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Account">
 *           &lt;xs:complexType>
 *             &lt;xs:simpleContent>
 *               &lt;xs:extension base="xs:string">
 *                 &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:simpleContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="AssocCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class DiscountProgramType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private String accountString;
    private String accountRefs;
    private String assocCode;
    private String name;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getAccountString() {
        return accountString;
    }

    /** 
     * Set the extension value.
     * 
     * @param accountString
     */
    public void setAccountString(String accountString) {
        this.accountString = accountString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getAccountRefs() {
        return accountRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param accountRefs
     */
    public void setAccountRefs(String accountRefs) {
        this.accountRefs = accountRefs;
    }

    /** 
     * Get the 'AssocCode' element value. Code for an organization or assocIation which owns or sponsors a particular discount program which an airline may support (discount progam support could be in on a bilateral basis). 

    Examples: AARP, AAA.
     * 
     * @return value
     */
    public String getAssocCode() {
        return assocCode;
    }

    /** 
     * Set the 'AssocCode' element value. Code for an organization or assocIation which owns or sponsors a particular discount program which an airline may support (discount progam support could be in on a bilateral basis). 

    Examples: AARP, AAA.
     * 
     * @param assocCode
     */
    public void setAssocCode(String assocCode) {
        this.assocCode = assocCode;
    }

    /** 
     * Get the 'Name' element value. Program name. 
    Example: AARP MEMBERSHIP
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Program name. 
    Example: AARP MEMBERSHIP
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
