
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * DISCOUNT core representation.NDC Capability: Discount

 1. Discount amount value may be represented as a fixed amount or a percentage.
 2. Contextual discount application (e.g. category) may be specified.
 3. Metadata may be defined.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiscountType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:DiscountAmount"/>
 *         &lt;xs:element ref="ns:DiscountPercent"/>
 *         &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DiscountType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private DiscountAmount discountAmount;
    private DiscountPercent discountPercent;
    private String application;
    private String description;

    /** 
     * Get the 'DiscountAmount' element value.
     * 
     * @return value
     */
    public DiscountAmount getDiscountAmount() {
        return discountAmount;
    }

    /** 
     * Set the 'DiscountAmount' element value.
     * 
     * @param discountAmount
     */
    public void setDiscountAmount(DiscountAmount discountAmount) {
        this.discountAmount = discountAmount;
    }

    /** 
     * Get the 'DiscountPercent' element value.
     * 
     * @return value
     */
    public DiscountPercent getDiscountPercent() {
        return discountPercent;
    }

    /** 
     * Set the 'DiscountPercent' element value.
     * 
     * @param discountPercent
     */
    public void setDiscountPercent(DiscountPercent discountPercent) {
        this.discountPercent = discountPercent;
    }

    /** 
     * Get the 'Application' element value. Discount Application.  Example: BAG
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Discount Application.  Example: BAG
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'Description' element value. Discount Description.
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Discount Description.
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }
}
