
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * A data type definition for Encoding Scheme.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EncSchemeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Detail" minOccurs="0">
 *       &lt;!-- Reference to inner class Detail -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Metadata" minOccurs="0">
 *       &lt;!-- Reference to inner class Metadata -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Key"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="OwnerCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="OwnerType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OwnerName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SchemeToken"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class EncSchemeType implements Serializable
{
    private Detail detail;
    private Metadata metadata;
    private String key;
    private String ownerCode;
    private String ownerType;
    private String ownerName;
    private String schemeToken;

    /** 
     * Get the 'Detail' element value.
     * 
     * @return value
     */
    public Detail getDetail() {
        return detail;
    }

    /** 
     * Set the 'Detail' element value.
     * 
     * @param detail
     */
    public void setDetail(Detail detail) {
        this.detail = detail;
    }

    /** 
     * Get the 'Metadata' element value.
     * 
     * @return value
     */
    public Metadata getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value.
     * 
     * @param metadata
     */
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Key' attribute value. Encoding Scheme globally unique instance/ class Key.

    Example: 8wOlMeZCT5+kR+mdfzsRlA
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' attribute value. Encoding Scheme globally unique instance/ class Key.

    Example: 8wOlMeZCT5+kR+mdfzsRlA
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'OwnerCode' attribute value. Owner Airline (or other entity) Code. Examples: BA, WIDGETCO
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' attribute value. Owner Airline (or other entity) Code. Examples: BA, WIDGETCO
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'OwnerType' attribute value. Scheme Owner Type. 

    Examples: Airline, Filed, ThirdParty

    Note: Supports pre-defined enumerated list and/ or bilaterally-agreed upon values.
     * 
     * @return value
     */
    public String getOwnerType() {
        return ownerType;
    }

    /** 
     * Set the 'OwnerType' attribute value. Scheme Owner Type. 

    Examples: Airline, Filed, ThirdParty

    Note: Supports pre-defined enumerated list and/ or bilaterally-agreed upon values.
     * 
     * @param ownerType
     */
    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    /** 
     * Get the 'OwnerName' attribute value. Scheme Owner Name. Example: British Airways
     * 
     * @return value
     */
    public String getOwnerName() {
        return ownerName;
    }

    /** 
     * Set the 'OwnerName' attribute value. Scheme Owner Name. Example: British Airways
     * 
     * @param ownerName
     */
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    /** 
     * Get the 'SchemeToken' attribute value. Encoding Scheme Token, e.g. reference association ID.

    Example: jZhJu7SORZeOMNpifElIkA
     * 
     * @return value
     */
    public String getSchemeToken() {
        return schemeToken;
    }

    /** 
     * Set the 'SchemeToken' attribute value. Encoding Scheme Token, e.g. reference association ID.

    Example: jZhJu7SORZeOMNpifElIkA
     * 
     * @param schemeToken
     */
    public void setSchemeToken(String schemeToken) {
        this.schemeToken = schemeToken;
    }
    /** 
     * Encoding Scheme Characteristics, including name, purpose, type, source uri, version and supported domains.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Detail" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SupportedDomain" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SupportedDomain -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="SchemeName"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="SchemePurpose"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Scheme_URI"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="SchemeVersion"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Detail implements Serializable
    {
        private List<SupportedDomain> supportedDomainList = new ArrayList<SupportedDomain>();
        private String schemeName;
        private String schemePurpose;
        private String schemeURI;
        private String schemeVersion;

        /** 
         * Get the list of 'SupportedDomain' element items.
         * 
         * @return list
         */
        public List<SupportedDomain> getSupportedDomainList() {
            return supportedDomainList;
        }

        /** 
         * Set the list of 'SupportedDomain' element items.
         * 
         * @param list
         */
        public void setSupportedDomainList(List<SupportedDomain> list) {
            supportedDomainList = list;
        }

        /** 
         * Get the 'SchemeName' attribute value. Encoding Scheme Name. Example: Optional Service Encoding
         * 
         * @return value
         */
        public String getSchemeName() {
            return schemeName;
        }

        /** 
         * Set the 'SchemeName' attribute value. Encoding Scheme Name. Example: Optional Service Encoding
         * 
         * @param schemeName
         */
        public void setSchemeName(String schemeName) {
            this.schemeName = schemeName;
        }

        /** 
         * Get the 'SchemePurpose' attribute value. Vocabulary Purpose. Example: Optional Service Encoding
         * 
         * @return value
         */
        public String getSchemePurpose() {
            return schemePurpose;
        }

        /** 
         * Set the 'SchemePurpose' attribute value. Vocabulary Purpose. Example: Optional Service Encoding
         * 
         * @param schemePurpose
         */
        public void setSchemePurpose(String schemePurpose) {
            this.schemePurpose = schemePurpose;
        }

        /** 
         * Get the 'Scheme_URI' attribute value. Encoding Scheme Source Location URI.
         * 
         * @return value
         */
        public String getSchemeURI() {
            return schemeURI;
        }

        /** 
         * Set the 'Scheme_URI' attribute value. Encoding Scheme Source Location URI.
         * 
         * @param schemeURI
         */
        public void setSchemeURI(String schemeURI) {
            this.schemeURI = schemeURI;
        }

        /** 
         * Get the 'SchemeVersion' attribute value. Encoding Scheme Version. Example: 1.7
         * 
         * @return value
         */
        public String getSchemeVersion() {
            return schemeVersion;
        }

        /** 
         * Set the 'SchemeVersion' attribute value. Encoding Scheme Version. Example: 1.7
         * 
         * @param schemeVersion
         */
        public void setSchemeVersion(String schemeVersion) {
            this.schemeVersion = schemeVersion;
        }
        /** 
         * Supported NDC Domains by scheme version.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SupportedDomain" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SupportedDomain implements Serializable
        {
            private String name;
            private String version;

            /** 
             * Get the 'Name' attribute value. Supported NDC Domain Name.

            Examples: Shopping, OrderManagement, PaymentTicketing, AirlineProfile, Utility

            Note: Supports pre-defined enumerated list and/ or bilaterally-agreed upon values.
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'Name' attribute value. Supported NDC Domain Name.

            Examples: Shopping, OrderManagement, PaymentTicketing, AirlineProfile, Utility

            Note: Supports pre-defined enumerated list and/ or bilaterally-agreed upon values.
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }

            /** 
             * Get the 'Version' attribute value. Associated Encoding Scheme Version(s). Example: 1.7, 1.0 - 1.7
             * 
             * @return value
             */
            public String getVersion() {
                return version;
            }

            /** 
             * Set the 'Version' attribute value. Associated Encoding Scheme Version(s). Example: 1.7, 1.0 - 1.7
             * 
             * @param version
             */
            public void setVersion(String version) {
                this.version = version;
            }
        }
    }
    /** 
     * Encoding Scheme Metadata, including timestamp and remark.

    Note: Information and/ or capabilities specified in Metadata may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation is not dictated by this specification.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Metadata" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:MetaBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:RemarkType" name="Remarks" minOccurs="0" maxOccurs="1"/>
     *         &lt;/xs:sequence>
     *         &lt;xs:attribute type="xs:dateTime" use="optional" name="Timestamp"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Metadata extends MetaBaseType implements Serializable
    {
        private RemarkType remarks;
        private Date timestamp;

        /** 
         * Get the 'Remarks' element value. Remark(s).
         * 
         * @return value
         */
        public RemarkType getRemarks() {
            return remarks;
        }

        /** 
         * Set the 'Remarks' element value. Remark(s).
         * 
         * @param remarks
         */
        public void setRemarks(RemarkType remarks) {
            this.remarks = remarks;
        }

        /** 
         * Get the 'Timestamp' attribute value. Scheme Timestamp. Example: 2017-01-13T13:59:38Z
         * 
         * @return value
         */
        public Date getTimestamp() {
            return timestamp;
        }

        /** 
         * Set the 'Timestamp' attribute value. Scheme Timestamp. Example: 2017-01-13T13:59:38Z
         * 
         * @param timestamp
         */
        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }
    }
}
