
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * EQUIVALENT FARE TRANSACTION definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFareTransactionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
 *     &lt;xs:element type="ns:CouponPurposeListType" name="Purpose" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="EquivRate"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class EquivFareTransactionType implements Serializable
{
    private CurrencyAmountOptType amount;
    private CouponPurposeListType purpose;
    private BigDecimal equivRate;

    /** 
     * Get the 'Amount' element value. Used to specify the equivalent, equivalent net or equivalent sell paid fare. Example 160 USD
     * 
     * @return value
     */
    public CurrencyAmountOptType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Used to specify the equivalent, equivalent net or equivalent sell paid fare. Example 160 USD
     * 
     * @param amount
     */
    public void setAmount(CurrencyAmountOptType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Purpose' element value. Equivalent Fare Transaction Purpose. Example: Base, Net, Refund, Sell

    Note: This is used to indicate if this is base or equivalent fare transaction information.
     * 
     * @return value
     */
    public CouponPurposeListType getPurpose() {
        return purpose;
    }

    /** 
     * Set the 'Purpose' element value. Equivalent Fare Transaction Purpose. Example: Base, Net, Refund, Sell

    Note: This is used to indicate if this is base or equivalent fare transaction information.
     * 
     * @param purpose
     */
    public void setPurpose(CouponPurposeListType purpose) {
        this.purpose = purpose;
    }

    /** 
     * Get the 'EquivRate' attribute value. Conversion rate. Example: 1.25

    Note: This is the BSR and/ or BBR used to convert the tax/fee/charge filed amount from the filed currency into the tax/fee/charge amount in currency of country of payment.
     * 
     * @return value
     */
    public BigDecimal getEquivRate() {
        return equivRate;
    }

    /** 
     * Set the 'EquivRate' attribute value. Conversion rate. Example: 1.25

    Note: This is the BSR and/ or BBR used to convert the tax/fee/charge filed amount from the filed currency into the tax/fee/charge amount in currency of country of payment.
     * 
     * @param equivRate
     */
    public void setEquivRate(BigDecimal equivRate) {
        this.equivRate = equivRate;
    }
}
