
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * SEAT MAP DISPLAY definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExitPositionType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Rows" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Rows -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:SegmentReference" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ExitPositionType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private List<Rows> rowList = new ArrayList<Rows>();
    private SegmentReference segmentReference;

    /** 
     * Get the list of 'Rows' element items.
     * 
     * @return list
     */
    public List<Rows> getRowList() {
        return rowList;
    }

    /** 
     * Set the list of 'Rows' element items.
     * 
     * @param list
     */
    public void setRowList(List<Rows> list) {
        rowList = list;
    }

    /** 
     * Get the 'SegmentReference' element value.
     * 
     * @return value
     */
    public SegmentReference getSegmentReference() {
        return segmentReference;
    }

    /** 
     * Set the 'SegmentReference' element value.
     * 
     * @param segmentReference
     */
    public void setSegmentReference(SegmentReference segmentReference) {
        this.segmentReference = segmentReference;
    }
    /** 
     * EXIT row detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rows" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="First">
     *             &lt;xs:complexType>
     *               &lt;xs:simpleContent>
     *                 &lt;xs:extension base="xs:string">
     *                   &lt;xs:attribute type="xs:anySimpleType" name="Columns"/>
     *                 &lt;/xs:extension>
     *               &lt;/xs:simpleContent>
     *             &lt;/xs:complexType>
     *           &lt;/xs:element>
     *           &lt;xs:element name="Last">
     *             &lt;xs:complexType>
     *               &lt;xs:simpleContent>
     *                 &lt;xs:extension base="xs:string">
     *                   &lt;xs:attribute type="xs:anySimpleType" name="Columns"/>
     *                 &lt;/xs:extension>
     *               &lt;/xs:simpleContent>
     *             &lt;/xs:complexType>
     *           &lt;/xs:element>
     *           &lt;xs:element type="ns:CodesetType" name="Position" minOccurs="0"/>
     *           &lt;xs:element ref="ns:CabinType" minOccurs="0"/>
     *           &lt;xs:element ref="ns:SegmentReference" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *         &lt;xs:attribute type="xs:boolean" use="optional" name="UpperDeckInd"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Rows extends AssociatedObjectBaseType implements
        Serializable
    {
        private String firstString;
        private String firstColumns;
        private String lastString;
        private String lastColumns;
        private CodesetType position;
        private CabinType cabinType;
        private SegmentReference segmentReference;
        private Boolean upperDeckInd;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getFirstString() {
            return firstString;
        }

        /** 
         * Set the extension value.
         * 
         * @param firstString
         */
        public void setFirstString(String firstString) {
            this.firstString = firstString;
        }

        /** 
         * Get the 'Columns' attribute value. Specifies the exit row position in wide body Aircraft.
         * 
         * @return value
         */
        public String getFirstColumns() {
            return firstColumns;
        }

        /** 
         * Set the 'Columns' attribute value. Specifies the exit row position in wide body Aircraft.
         * 
         * @param firstColumns
         */
        public void setFirstColumns(String firstColumns) {
            this.firstColumns = firstColumns;
        }

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getLastString() {
            return lastString;
        }

        /** 
         * Set the extension value.
         * 
         * @param lastString
         */
        public void setLastString(String lastString) {
            this.lastString = lastString;
        }

        /** 
         * Get the 'Columns' attribute value. Specifies the exit row position in wide body Aircraft.
         * 
         * @return value
         */
        public String getLastColumns() {
            return lastColumns;
        }

        /** 
         * Set the 'Columns' attribute value. Specifies the exit row position in wide body Aircraft.
         * 
         * @param lastColumns
         */
        public void setLastColumns(String lastColumns) {
            this.lastColumns = lastColumns;
        }

        /** 
         * Get the 'Position' element value. Exit row position.
        Examples:
        B (Back)
        C (Center section)
        F (Front)
        FB (Front and Back)
        FMB (Front, Middle and Back)
        L (Left side section)
        LC (Left center section)
        R (Right side section)
        RC (Right center section)

        Encoding Scheme: IATA PADIS Code List for data element 3227 - Place/Location Qualifier
         * 
         * @return value
         */
        public CodesetType getPosition() {
            return position;
        }

        /** 
         * Set the 'Position' element value. Exit row position.
        Examples:
        B (Back)
        C (Center section)
        F (Front)
        FB (Front and Back)
        FMB (Front, Middle and Back)
        L (Left side section)
        LC (Left center section)
        R (Right side section)
        RC (Right center section)

        Encoding Scheme: IATA PADIS Code List for data element 3227 - Place/Location Qualifier
         * 
         * @param position
         */
        public void setPosition(CodesetType position) {
            this.position = position;
        }

        /** 
         * Get the 'CabinType' element value.
         * 
         * @return value
         */
        public CabinType getCabinType() {
            return cabinType;
        }

        /** 
         * Set the 'CabinType' element value.
         * 
         * @param cabinType
         */
        public void setCabinType(CabinType cabinType) {
            this.cabinType = cabinType;
        }

        /** 
         * Get the 'SegmentReference' element value.
         * 
         * @return value
         */
        public SegmentReference getSegmentReference() {
            return segmentReference;
        }

        /** 
         * Set the 'SegmentReference' element value.
         * 
         * @param segmentReference
         */
        public void setSegmentReference(SegmentReference segmentReference) {
            this.segmentReference = segmentReference;
        }

        /** 
         * Get the 'UpperDeckInd' attribute value. When TRUE, this section is on the upper deck of an aircraft.

        Note: If being used in a Seat Map, this may indicate that a separate seatmap graphic is requested.
         * 
         * @return value
         */
        public Boolean getUpperDeckInd() {
            return upperDeckInd;
        }

        /** 
         * Set the 'UpperDeckInd' attribute value. When TRUE, this section is on the upper deck of an aircraft.

        Note: If being used in a Seat Map, this may indicate that a separate seatmap graphic is requested.
         * 
         * @param upperDeckInd
         */
        public void setUpperDeckInd(Boolean upperDeckInd) {
            this.upperDeckInd = upperDeckInd;
        }
    }
}
