
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Detail Frequent Traveler Program.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FQTV_ProgramDetailType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:FQTV_ProgramSummaryType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Alliances" minOccurs="0">
 *           &lt;!-- Reference to inner class Alliances -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FQTVProgramDetailType extends FQTVProgramSummaryType implements
    Serializable
{
    private Alliances alliances;

    /** 
     * Get the 'Alliances' element value.
     * 
     * @return value
     */
    public Alliances getAlliances() {
        return alliances;
    }

    /** 
     * Set the 'Alliances' element value.
     * 
     * @param alliances
     */
    public void setAlliances(Alliances alliances) {
        this.alliances = alliances;
    }
    /** 
     * FQTV Program Alliances(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Alliances" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FQTV_AllianceType" name="Alliance" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Alliances implements Serializable
    {
        private List<FQTVAllianceType> allianceList = new ArrayList<FQTVAllianceType>();

        /** 
         * Get the list of 'Alliance' element items. FQTV Alliance detail.
         * 
         * @return list
         */
        public List<FQTVAllianceType> getAllianceList() {
            return allianceList;
        }

        /** 
         * Set the list of 'Alliance' element items. FQTV Alliance detail.
         * 
         * @param list
         */
        public void setAllianceList(List<FQTVAllianceType> list) {
            allianceList = list;
        }
    }
}
