
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Fare Preferences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FarePreferencesType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Types" minOccurs="0">
 *           &lt;!-- Reference to inner class Types -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="FareCodes" minOccurs="0">
 *           &lt;!-- Reference to inner class FareCodes -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="TicketDesigs" minOccurs="0">
 *           &lt;!-- Reference to inner class TicketDesigs -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Exclusion" minOccurs="0">
 *           &lt;!-- Reference to inner class Exclusion -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:GroupFarePreferencesType" name="GroupFare" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FarePreferencesType extends AssociatedObjectBaseType implements
    Serializable
{
    private Types types;
    private FareCodes fareCodes;
    private TicketDesigs ticketDesigs;
    private Exclusion exclusion;
    private GroupFarePreferencesType groupFare;
    private PreferenceAttrGroup preferenceAttrGroup;

    /** 
     * Get the 'Types' element value.
     * 
     * @return value
     */
    public Types getTypes() {
        return types;
    }

    /** 
     * Set the 'Types' element value.
     * 
     * @param types
     */
    public void setTypes(Types types) {
        this.types = types;
    }

    /** 
     * Get the 'FareCodes' element value.
     * 
     * @return value
     */
    public FareCodes getFareCodes() {
        return fareCodes;
    }

    /** 
     * Set the 'FareCodes' element value.
     * 
     * @param fareCodes
     */
    public void setFareCodes(FareCodes fareCodes) {
        this.fareCodes = fareCodes;
    }

    /** 
     * Get the 'TicketDesigs' element value.
     * 
     * @return value
     */
    public TicketDesigs getTicketDesigs() {
        return ticketDesigs;
    }

    /** 
     * Set the 'TicketDesigs' element value.
     * 
     * @param ticketDesigs
     */
    public void setTicketDesigs(TicketDesigs ticketDesigs) {
        this.ticketDesigs = ticketDesigs;
    }

    /** 
     * Get the 'Exclusion' element value.
     * 
     * @return value
     */
    public Exclusion getExclusion() {
        return exclusion;
    }

    /** 
     * Set the 'Exclusion' element value.
     * 
     * @param exclusion
     */
    public void setExclusion(Exclusion exclusion) {
        this.exclusion = exclusion;
    }

    /** 
     * Get the 'GroupFare' element value. Group Fare preferences by passenger type.
     * 
     * @return value
     */
    public GroupFarePreferencesType getGroupFare() {
        return groupFare;
    }

    /** 
     * Set the 'GroupFare' element value. Group Fare preferences by passenger type.
     * 
     * @param groupFare
     */
    public void setGroupFare(GroupFarePreferencesType groupFare) {
        this.groupFare = groupFare;
    }

    /** 
     * Get the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public PreferenceAttrGroup getPreferenceAttrGroup() {
        return preferenceAttrGroup;
    }

    /** 
     * Set the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @param preferenceAttrGroup
     */
    public void setPreferenceAttrGroup(PreferenceAttrGroup preferenceAttrGroup) {
        this.preferenceAttrGroup = preferenceAttrGroup;
    }
    /** 
     * Fare Type(s) with preference level.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Types" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Type" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Type -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Types implements Serializable
    {
        private List<Type> typeList = new ArrayList<Type>();

        /** 
         * Get the list of 'Type' element items.
         * 
         * @return list
         */
        public List<Type> getTypeList() {
            return typeList;
        }

        /** 
         * Set the list of 'Type' element items.
         * 
         * @param list
         */
        public void setTypeList(List<Type> list) {
            typeList = list;
        }
        /** 
         * Fare type.  Examples: 70J-Published Fares, 749-Negotiated Fares, 756-One Way Fare, 
        758-Private Fares

        Encoding Scheme: PADIS codeset element 9910 - Fare Qualifier
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Type" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:CodesetType">
         *         &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Type extends CodesetType implements Serializable
        {
            private PreferenceAttrGroup preferenceAttrGroup;

            /** 
             * Get the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @return value
             */
            public PreferenceAttrGroup getPreferenceAttrGroup() {
                return preferenceAttrGroup;
            }

            /** 
             * Set the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @param preferenceAttrGroup
             */
            public void setPreferenceAttrGroup(
                    PreferenceAttrGroup preferenceAttrGroup) {
                this.preferenceAttrGroup = preferenceAttrGroup;
            }
        }
    }
    /** 
     * A code that gives information regarding the type of fare, class entitlement, minimum and maximum validity, reservations entitlement, seasonality, days of travel and advertising or sales restrictions.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCodes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Code" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Code -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareCodes implements Serializable
    {
        private List<Code> codeList = new ArrayList<Code>();
        private PreferenceAttrGroup preferenceAttrGroup;

        /** 
         * Get the list of 'Code' element items.
         * 
         * @return list
         */
        public List<Code> getCodeList() {
            return codeList;
        }

        /** 
         * Set the list of 'Code' element items.
         * 
         * @param list
         */
        public void setCodeList(List<Code> list) {
            codeList = list;
        }

        /** 
         * Get the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public PreferenceAttrGroup getPreferenceAttrGroup() {
            return preferenceAttrGroup;
        }

        /** 
         * Set the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @param preferenceAttrGroup
         */
        public void setPreferenceAttrGroup(
                PreferenceAttrGroup preferenceAttrGroup) {
            this.preferenceAttrGroup = preferenceAttrGroup;
        }
        /** 
         * Fare Basis Code with optional application.  
        Example: Y26
        Used in conjunction with Application (Requested, Ticketed, Other)
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:FareBasisCodeType">
         *         &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Code extends FareBasisCodeType implements
            Serializable
        {
            private PreferenceAttrGroup preferenceAttrGroup;

            /** 
             * Get the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @return value
             */
            public PreferenceAttrGroup getPreferenceAttrGroup() {
                return preferenceAttrGroup;
            }

            /** 
             * Set the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @param preferenceAttrGroup
             */
            public void setPreferenceAttrGroup(
                    PreferenceAttrGroup preferenceAttrGroup) {
                this.preferenceAttrGroup = preferenceAttrGroup;
            }
        }
    }
    /** 
     * The applicable code as provided for in A4A SIPP Resolution 110.16 or IATA Resolution 728. Further ticket 
    designators will be reported at the Fare Component level as matched from a Ticket Discount, ATPCO 
    Category 35, Category 25 or Category 19-22.

     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDesigs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TicketDesig" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class TicketDesig -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketDesigs implements Serializable
    {
        private List<TicketDesig> ticketDesigList = new ArrayList<TicketDesig>();
        private PreferenceAttrGroup preferenceAttrGroup;

        /** 
         * Get the list of 'TicketDesig' element items.
         * 
         * @return list
         */
        public List<TicketDesig> getTicketDesigList() {
            return ticketDesigList;
        }

        /** 
         * Set the list of 'TicketDesig' element items.
         * 
         * @param list
         */
        public void setTicketDesigList(List<TicketDesig> list) {
            ticketDesigList = list;
        }

        /** 
         * Get the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public PreferenceAttrGroup getPreferenceAttrGroup() {
            return preferenceAttrGroup;
        }

        /** 
         * Set the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @param preferenceAttrGroup
         */
        public void setPreferenceAttrGroup(
                PreferenceAttrGroup preferenceAttrGroup) {
            this.preferenceAttrGroup = preferenceAttrGroup;
        }
        /** 
         * Ticket designator detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDesig" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:TicketDesignatorType">
         *         &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketDesig extends TicketDesignatorType implements
            Serializable
        {
            private PreferenceAttrGroup preferenceAttrGroup;

            /** 
             * Get the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @return value
             */
            public PreferenceAttrGroup getPreferenceAttrGroup() {
                return preferenceAttrGroup;
            }

            /** 
             * Set the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @param preferenceAttrGroup
             */
            public void setPreferenceAttrGroup(
                    PreferenceAttrGroup preferenceAttrGroup) {
                this.preferenceAttrGroup = preferenceAttrGroup;
            }
        }
    }
    /** 
     * Contains indicators allowing for different restricted fare types to be be excluded.

     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Exclusion" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:boolean" name="NoMinStayInd" minOccurs="0"/>
     *       &lt;xs:element type="xs:boolean" name="NoMaxStayInd" minOccurs="0"/>
     *       &lt;xs:element type="xs:boolean" name="NoAdvPurchaseInd" minOccurs="0"/>
     *       &lt;xs:element type="xs:boolean" name="NoPenaltyInd" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Exclusion implements Serializable
    {
        private Boolean noMinStayInd;
        private Boolean noMaxStayInd;
        private Boolean noAdvPurchaseInd;
        private Boolean noPenaltyInd;

        /** 
         * Get the 'NoMinStayInd' element value. When TRUE, do not return fares with minimum stay restrictions.
         * 
         * @return value
         */
        public Boolean getNoMinStayInd() {
            return noMinStayInd;
        }

        /** 
         * Set the 'NoMinStayInd' element value. When TRUE, do not return fares with minimum stay restrictions.
         * 
         * @param noMinStayInd
         */
        public void setNoMinStayInd(Boolean noMinStayInd) {
            this.noMinStayInd = noMinStayInd;
        }

        /** 
         * Get the 'NoMaxStayInd' element value. When TRUE, do not return fares with maximum stay restrictions.
         * 
         * @return value
         */
        public Boolean getNoMaxStayInd() {
            return noMaxStayInd;
        }

        /** 
         * Set the 'NoMaxStayInd' element value. When TRUE, do not return fares with maximum stay restrictions.
         * 
         * @param noMaxStayInd
         */
        public void setNoMaxStayInd(Boolean noMaxStayInd) {
            this.noMaxStayInd = noMaxStayInd;
        }

        /** 
         * Get the 'NoAdvPurchaseInd' element value. When TRUE, do not return fares with advance purchase restrictions.
         * 
         * @return value
         */
        public Boolean getNoAdvPurchaseInd() {
            return noAdvPurchaseInd;
        }

        /** 
         * Set the 'NoAdvPurchaseInd' element value. When TRUE, do not return fares with advance purchase restrictions.
         * 
         * @param noAdvPurchaseInd
         */
        public void setNoAdvPurchaseInd(Boolean noAdvPurchaseInd) {
            this.noAdvPurchaseInd = noAdvPurchaseInd;
        }

        /** 
         * Get the 'NoPenaltyInd' element value. When TRUE, do not return fares with penalties.
         * 
         * @return value
         */
        public Boolean getNoPenaltyInd() {
            return noPenaltyInd;
        }

        /** 
         * Set the 'NoPenaltyInd' element value. When TRUE, do not return fares with penalties.
         * 
         * @param noPenaltyInd
         */
        public void setNoPenaltyInd(Boolean noPenaltyInd) {
            this.noPenaltyInd = noPenaltyInd;
        }
    }
}
