
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * FARE BASE PRICE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FarePriceBaseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CurrencyAmountOptType" name="BaseAmount" minOccurs="0"/>
 *     &lt;xs:element ref="ns:FareFiledIn" minOccurs="0"/>
 *     &lt;xs:element name="Surcharges" minOccurs="0">
 *       &lt;!-- Reference to inner class Surcharges -->
 *     &lt;/xs:element>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:AwardPriceUnitType" name="AwardPricing" minOccurs="0"/>
 *       &lt;xs:element type="ns:CombinationPriceType" name="CombinationPricing" minOccurs="0"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FarePriceBaseType implements Serializable
{
    private CurrencyAmountOptType baseAmount;
    private FareFilingType fareFiledIn;
    private Surcharges surcharges;
    private int choiceSelect = -1;
    private static final int AWARD_PRICING_CHOICE = 0;
    private static final int COMBINATION_PRICING_CHOICE = 1;
    private AwardPriceUnitType awardPricing;
    private CombinationPriceType combinationPricing;

    /** 
     * Get the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @return value
     */
    public CurrencyAmountOptType getBaseAmount() {
        return baseAmount;
    }

    /** 
     * Set the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @param baseAmount
     */
    public void setBaseAmount(CurrencyAmountOptType baseAmount) {
        this.baseAmount = baseAmount;
    }

    /** 
     * Get the 'FareFiledIn' element value.
     * 
     * @return value
     */
    public FareFilingType getFareFiledIn() {
        return fareFiledIn;
    }

    /** 
     * Set the 'FareFiledIn' element value.
     * 
     * @param fareFiledIn
     */
    public void setFareFiledIn(FareFilingType fareFiledIn) {
        this.fareFiledIn = fareFiledIn;
    }

    /** 
     * Get the 'Surcharges' element value.
     * 
     * @return value
     */
    public Surcharges getSurcharges() {
        return surcharges;
    }

    /** 
     * Set the 'Surcharges' element value.
     * 
     * @param surcharges
     */
    public void setSurcharges(Surcharges surcharges) {
        this.surcharges = surcharges;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AwardPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAwardPricing() {
        return choiceSelect == AWARD_PRICING_CHOICE;
    }

    /** 
     * Get the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
     * 
     * @return value
     */
    public AwardPriceUnitType getAwardPricing() {
        return awardPricing;
    }

    /** 
     * Set the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
     * 
     * @param awardPricing
     */
    public void setAwardPricing(AwardPriceUnitType awardPricing) {
        setChoiceSelect(AWARD_PRICING_CHOICE);
        this.awardPricing = awardPricing;
    }

    /** 
     * Check if CombinationPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCombinationPricing() {
        return choiceSelect == COMBINATION_PRICING_CHOICE;
    }

    /** 
     * Get the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
     * 
     * @return value
     */
    public CombinationPriceType getCombinationPricing() {
        return combinationPricing;
    }

    /** 
     * Set the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
     * 
     * @param combinationPricing
     */
    public void setCombinationPricing(CombinationPriceType combinationPricing) {
        setChoiceSelect(COMBINATION_PRICING_CHOICE);
        this.combinationPricing = combinationPricing;
    }
    /** 
     * Applicable Surcharge(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FeeSurchargeType" name="Surcharge" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Surcharges implements Serializable
    {
        private List<FeeSurchargeType> surchargeList = new ArrayList<FeeSurchargeType>();

        /** 
         * Get the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @return list
         */
        public List<FeeSurchargeType> getSurchargeList() {
            return surchargeList;
        }

        /** 
         * Set the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @param list
         */
        public void setSurchargeList(List<FeeSurchargeType> list) {
            surchargeList = list;
        }
    }
}
