
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Fare Rule Subset for this Fare Component.

 Note: For full fare rule retrieval, use the FareRulesRQ/RS message pair.NDC Capability Model: FARE - FARE RULES - REMARKS

 ============
 Description
 ============
 Fare Rule collection (group) for an associated Fare Component.

 ============
 Representation(s)
 ============
 • Scheme: IATA PADIS codeset FRC-Fare Rule Category

 ============
 Feature(s)
 ============
 • Fare Basis Code-associated Fare Rule Category Code and Description.

 ============
 Metadata
 ============
 • FareRuleMetadata
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRulesRemarks">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="FareRulesRemark" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class FareRulesRemark -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class FareRulesRemarks implements Serializable
{
    private List<FareRulesRemark> fareRulesRemarkList = new ArrayList<FareRulesRemark>();

    /** 
     * Get the list of 'FareRulesRemark' element items.
     * 
     * @return list
     */
    public List<FareRulesRemark> getFareRulesRemarkList() {
        return fareRulesRemarkList;
    }

    /** 
     * Set the list of 'FareRulesRemark' element items.
     * 
     * @param list
     */
    public void setFareRulesRemarkList(List<FareRulesRemark> list) {
        fareRulesRemarkList = list;
    }
    /** 
     * Category-Related Fare Rule Subset.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRulesRemark" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:CodesetType" name="Category"/>
     *           &lt;xs:element type="xs:string" name="Text"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareRulesRemark extends KeyWithMetaObjectBaseType
        implements Serializable
    {
        private CodesetType category;
        private String text;

        /** 
         * Get the 'Category' element value. Fare rule category (associated with FareBasisCode.) 
        Example: ACC (Accompanied Travel)

        Encoding Scheme: IATA PADIS codeset FRC-Fare Rule Category
         * 
         * @return value
         */
        public CodesetType getCategory() {
            return category;
        }

        /** 
         * Set the 'Category' element value. Fare rule category (associated with FareBasisCode.) 
        Example: ACC (Accompanied Travel)

        Encoding Scheme: IATA PADIS codeset FRC-Fare Rule Category
         * 
         * @param category
         */
        public void setCategory(CodesetType category) {
            this.category = category;
        }

        /** 
         * Get the 'Text' element value. Fare Rule Text.
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value. Fare Rule Text.
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }
    }
}
