
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Fare Rule Modification or Override Type contextual list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareWaiverRuleListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ExchangedReissued"/>
 *     &lt;xs:enumeration value="FareComponent"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FareWaiverRuleListType implements Serializable {
    EXCHANGED_REISSUED("ExchangedReissued"), FARE_COMPONENT("FareComponent"), OTHER(
            "Other");
    private final String value;

    private FareWaiverRuleListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FareWaiverRuleListType convert(String value) {
        for (FareWaiverRuleListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
