
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for a Fee/ Surcharge.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeSurchargeType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Total">
 *           &lt;xs:complexType>
 *             &lt;xs:complexContent>
 *               &lt;xs:extension base="ns:CurrencyAmountOptType">
 *                 &lt;xs:attribute type="xs:boolean" use="optional" name="refundInd"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:complexContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Breakdown" minOccurs="0">
 *           &lt;!-- Reference to inner class Breakdown -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FeeSurchargeType extends AssociatedObjectBaseType implements
    Serializable
{
    private CurrencyAmountOptType totalCurrencyAmountOptType;
    private Boolean totalRefundInd;
    private Breakdown breakdown;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public CurrencyAmountOptType getTotalCurrencyAmountOptType() {
        return totalCurrencyAmountOptType;
    }

    /** 
     * Set the extension value.
     * 
     * @param totalCurrencyAmountOptType
     */
    public void setTotalCurrencyAmountOptType(
            CurrencyAmountOptType totalCurrencyAmountOptType) {
        this.totalCurrencyAmountOptType = totalCurrencyAmountOptType;
    }

    /** 
     * Get the 'refundInd' attribute value. When TRUE, all fee/ surcharge amounts are refundable.
    Example: TRUE
     * 
     * @return value
     */
    public Boolean getTotalRefundInd() {
        return totalRefundInd;
    }

    /** 
     * Set the 'refundInd' attribute value. When TRUE, all fee/ surcharge amounts are refundable.
    Example: TRUE
     * 
     * @param totalRefundInd
     */
    public void setTotalRefundInd(Boolean totalRefundInd) {
        this.totalRefundInd = totalRefundInd;
    }

    /** 
     * Get the 'Breakdown' element value.
     * 
     * @return value
     */
    public Breakdown getBreakdown() {
        return breakdown;
    }

    /** 
     * Set the 'Breakdown' element value.
     * 
     * @param breakdown
     */
    public void setBreakdown(Breakdown breakdown) {
        this.breakdown = breakdown;
    }
    /** 
     * The fee, charge or surcharge amount information per traveler.

     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Breakdown" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Fee" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Fee -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Breakdown implements Serializable
    {
        private List<Fee> feeList = new ArrayList<Fee>();

        /** 
         * Get the list of 'Fee' element items.
         * 
         * @return list
         */
        public List<Fee> getFeeList() {
            return feeList;
        }

        /** 
         * Set the list of 'Fee' element items.
         * 
         * @param list
         */
        public void setFeeList(List<Fee> list) {
            feeList = list;
        }
        /** 
         * Individual fee/ surcharge information would appear on the accontable document.

        Note: Separate structure for individual TAX details is also present.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fee" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
         *       &lt;xs:element type="ns:CurrencyAmountOptType" name="LocalAmount" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Designator" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="Nature" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="ApproxInd"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="RefundInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Fee implements Serializable
        {
            private CurrencyAmountOptType amount;
            private CurrencyAmountOptType localAmount;
            private String designator;
            private String description;
            private String nature;
            private String refs;
            private Boolean approxInd;
            private Boolean refundInd;

            /** 
             * Get the 'Amount' element value. Fee Amount. Example: 500 USD
             * 
             * @return value
             */
            public CurrencyAmountOptType getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' element value. Fee Amount. Example: 500 USD
             * 
             * @param amount
             */
            public void setAmount(CurrencyAmountOptType amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'LocalAmount' element value. Local fee amount. Example: 7 CHF
             * 
             * @return value
             */
            public CurrencyAmountOptType getLocalAmount() {
                return localAmount;
            }

            /** 
             * Set the 'LocalAmount' element value. Local fee amount. Example: 7 CHF
             * 
             * @param localAmount
             */
            public void setLocalAmount(CurrencyAmountOptType localAmount) {
                this.localAmount = localAmount;
            }

            /** 
             * Get the 'Designator' element value. Fee designator. Example: USC
             * 
             * @return value
             */
            public String getDesignator() {
                return designator;
            }

            /** 
             * Set the 'Designator' element value. Fee designator. Example: USC
             * 
             * @param designator
             */
            public void setDesignator(String designator) {
                this.designator = designator;
            }

            /** 
             * Get the 'Description' element value. Fee/ surcharge Description.  Example: U.S Customs User Fee
             * 
             * @return value
             */
            public String getDescription() {
                return description;
            }

            /** 
             * Set the 'Description' element value. Fee/ surcharge Description.  Example: U.S Customs User Fee
             * 
             * @param description
             */
            public void setDescription(String description) {
                this.description = description;
            }

            /** 
             * Get the 'Nature' element value. Fee nature.
             * 
             * @return value
             */
            public String getNature() {
                return nature;
            }

            /** 
             * Set the 'Nature' element value. Fee nature.
             * 
             * @param nature
             */
            public void setNature(String nature) {
                this.nature = nature;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }

            /** 
             * Get the 'ApproxInd' attribute value. When TRUE, this fee is approximate.
             * 
             * @return value
             */
            public Boolean getApproxInd() {
                return approxInd;
            }

            /** 
             * Set the 'ApproxInd' attribute value. When TRUE, this fee is approximate.
             * 
             * @param approxInd
             */
            public void setApproxInd(Boolean approxInd) {
                this.approxInd = approxInd;
            }

            /** 
             * Get the 'RefundInd' attribute value. When TRUE, this fee amount is refundable.
             * 
             * @return value
             */
            public Boolean getRefundInd() {
                return refundInd;
            }

            /** 
             * Set the 'RefundInd' attribute value. When TRUE, this fee amount is refundable.
             * 
             * @param refundInd
             */
            public void setRefundInd(Boolean refundInd) {
                this.refundInd = refundInd;
            }
        }
    }
}
