
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Cabin Core.

 Cabin code.
 Example: F
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightCabin_CoreType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="CabinDesignator">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attribute type="xs:boolean" name="AllCabins"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="MarketingName" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FlightCabinCoreType implements Serializable
{
    private String cabinDesignatorString;
    private Boolean cabinDesignatorAllCabins;
    private String marketingName;
    private String refs;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getCabinDesignatorString() {
        return cabinDesignatorString;
    }

    /** 
     * Set the extension value.
     * 
     * @param cabinDesignatorString
     */
    public void setCabinDesignatorString(String cabinDesignatorString) {
        this.cabinDesignatorString = cabinDesignatorString;
    }

    /** 
     * Get the 'AllCabins' attribute value. When TRUE indicates that it applies to all Cabins, otherwise the specified Cabin applies.
     * 
     * @return value
     */
    public Boolean getCabinDesignatorAllCabins() {
        return cabinDesignatorAllCabins;
    }

    /** 
     * Set the 'AllCabins' attribute value. When TRUE indicates that it applies to all Cabins, otherwise the specified Cabin applies.
     * 
     * @param cabinDesignatorAllCabins
     */
    public void setCabinDesignatorAllCabins(Boolean cabinDesignatorAllCabins) {
        this.cabinDesignatorAllCabins = cabinDesignatorAllCabins;
    }

    /** 
     * Get the 'MarketingName' element value. Cabin Marketing Name. Example: Premium Economy
     * 
     * @return value
     */
    public String getMarketingName() {
        return marketingName;
    }

    /** 
     * Set the 'MarketingName' element value. Cabin Marketing Name. Example: Premium Economy
     * 
     * @param marketingName
     */
    public void setMarketingName(String marketingName) {
        this.marketingName = marketingName;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
