
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * FLIGHT Order Offer Item.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightItemOfferType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:FlightPriceType" name="Pricing" minOccurs="0"/>
 *         &lt;xs:element name="Flight" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Flight -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="AircraftEquipment" minOccurs="0">
 *           &lt;!-- Reference to inner class AircraftEquipment -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:OrderFareDetailType" name="FareDetail" minOccurs="0"/>
 *         &lt;xs:element ref="ns:TotalJourney" minOccurs="0"/>
 *         &lt;xs:element name="Passengers" minOccurs="0">
 *           &lt;!-- Reference to inner class Passengers -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Details" minOccurs="0">
 *           &lt;!-- Reference to inner class Details -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightItemOfferType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private FlightPriceType pricing;
    private List<Flight> flightList = new ArrayList<Flight>();
    private AircraftEquipment aircraftEquipment;
    private OrderFareDetailType fareDetail;
    private TotalJourneyType totalJourney;
    private Passengers passengers;
    private Details details;

    /** 
     * Get the 'Pricing' element value. Contains all pricing information related to a flight.
     * 
     * @return value
     */
    public FlightPriceType getPricing() {
        return pricing;
    }

    /** 
     * Set the 'Pricing' element value. Contains all pricing information related to a flight.
     * 
     * @param pricing
     */
    public void setPricing(FlightPriceType pricing) {
        this.pricing = pricing;
    }

    /** 
     * Get the list of 'Flight' element items.
     * 
     * @return list
     */
    public List<Flight> getFlightList() {
        return flightList;
    }

    /** 
     * Set the list of 'Flight' element items.
     * 
     * @param list
     */
    public void setFlightList(List<Flight> list) {
        flightList = list;
    }

    /** 
     * Get the 'AircraftEquipment' element value.
     * 
     * @return value
     */
    public AircraftEquipment getAircraftEquipment() {
        return aircraftEquipment;
    }

    /** 
     * Set the 'AircraftEquipment' element value.
     * 
     * @param aircraftEquipment
     */
    public void setAircraftEquipment(AircraftEquipment aircraftEquipment) {
        this.aircraftEquipment = aircraftEquipment;
    }

    /** 
     * Get the 'FareDetail' element value. Fare Detail.
     * 
     * @return value
     */
    public OrderFareDetailType getFareDetail() {
        return fareDetail;
    }

    /** 
     * Set the 'FareDetail' element value. Fare Detail.
     * 
     * @param fareDetail
     */
    public void setFareDetail(OrderFareDetailType fareDetail) {
        this.fareDetail = fareDetail;
    }

    /** 
     * Get the 'TotalJourney' element value.
     * 
     * @return value
     */
    public TotalJourneyType getTotalJourney() {
        return totalJourney;
    }

    /** 
     * Set the 'TotalJourney' element value.
     * 
     * @param totalJourney
     */
    public void setTotalJourney(TotalJourneyType totalJourney) {
        this.totalJourney = totalJourney;
    }

    /** 
     * Get the 'Passengers' element value.
     * 
     * @return value
     */
    public Passengers getPassengers() {
        return passengers;
    }

    /** 
     * Set the 'Passengers' element value.
     * 
     * @param passengers
     */
    public void setPassengers(Passengers passengers) {
        this.passengers = passengers;
    }

    /** 
     * Get the 'Details' element value.
     * 
     * @return value
     */
    public Details getDetails() {
        return details;
    }

    /** 
     * Set the 'Details' element value.
     * 
     * @param details
     */
    public void setDetails(Details details) {
        this.details = details;
    }
    /** 
     * Flight origin/ destination information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:SegmentKey" minOccurs="0"/>
     *       &lt;xs:element ref="ns:Departure"/>
     *       &lt;xs:element ref="ns:Arrival"/>
     *       &lt;xs:element type="ns:MarketingCarrierFlightType" name="MarketingCarrier"/>
     *       &lt;xs:element name="OperatingCarrier" minOccurs="0">
     *         &lt;!-- Reference to inner class OperatingCarrier -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:Equipment" minOccurs="0"/>
     *       &lt;xs:element ref="ns:CabinType" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ClassOfService" minOccurs="0"/>
     *       &lt;xs:element type="ns:FlightDetailType" name="Details" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *     &lt;xs:attribute type="xs:boolean" name="PricingInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="ConnectionInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="E_TicketInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="TicketlessInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Flight implements Serializable
    {
        private SegmentKey segmentKey;
        private FlightDepartureType departure;
        private FlightArrivalType arrival;
        private MarketingCarrierFlightType marketingCarrier;
        private OperatingCarrier operatingCarrier;
        private Equipment equipment;
        private CabinType cabinType;
        private FlightCOSCoreType classOfService;
        private FlightDetailType details;
        private String refs;
        private Boolean pricingInd;
        private Boolean connectionInd;
        private Boolean ETicketInd;
        private Boolean ticketlessInd;

        /** 
         * Get the 'SegmentKey' element value.
         * 
         * @return value
         */
        public SegmentKey getSegmentKey() {
            return segmentKey;
        }

        /** 
         * Set the 'SegmentKey' element value.
         * 
         * @param segmentKey
         */
        public void setSegmentKey(SegmentKey segmentKey) {
            this.segmentKey = segmentKey;
        }

        /** 
         * Get the 'Departure' element value.
         * 
         * @return value
         */
        public FlightDepartureType getDeparture() {
            return departure;
        }

        /** 
         * Set the 'Departure' element value.
         * 
         * @param departure
         */
        public void setDeparture(FlightDepartureType departure) {
            this.departure = departure;
        }

        /** 
         * Get the 'Arrival' element value.
         * 
         * @return value
         */
        public FlightArrivalType getArrival() {
            return arrival;
        }

        /** 
         * Set the 'Arrival' element value.
         * 
         * @param arrival
         */
        public void setArrival(FlightArrivalType arrival) {
            this.arrival = arrival;
        }

        /** 
         * Get the 'MarketingCarrier' element value. 
                          Marketing Carrier information. Notes: This is the carrier that sells with its own code as part of a code share agreement on a flight that is actually operated by another carrier.
                        
         * 
         * @return value
         */
        public MarketingCarrierFlightType getMarketingCarrier() {
            return marketingCarrier;
        }

        /** 
         * Set the 'MarketingCarrier' element value. 
                          Marketing Carrier information. Notes: This is the carrier that sells with its own code as part of a code share agreement on a flight that is actually operated by another carrier.
                        
         * 
         * @param marketingCarrier
         */
        public void setMarketingCarrier(
                MarketingCarrierFlightType marketingCarrier) {
            this.marketingCarrier = marketingCarrier;
        }

        /** 
         * Get the 'OperatingCarrier' element value.
         * 
         * @return value
         */
        public OperatingCarrier getOperatingCarrier() {
            return operatingCarrier;
        }

        /** 
         * Set the 'OperatingCarrier' element value.
         * 
         * @param operatingCarrier
         */
        public void setOperatingCarrier(OperatingCarrier operatingCarrier) {
            this.operatingCarrier = operatingCarrier;
        }

        /** 
         * Get the 'Equipment' element value.
         * 
         * @return value
         */
        public Equipment getEquipment() {
            return equipment;
        }

        /** 
         * Set the 'Equipment' element value.
         * 
         * @param equipment
         */
        public void setEquipment(Equipment equipment) {
            this.equipment = equipment;
        }

        /** 
         * Get the 'CabinType' element value.
         * 
         * @return value
         */
        public CabinType getCabinType() {
            return cabinType;
        }

        /** 
         * Set the 'CabinType' element value.
         * 
         * @param cabinType
         */
        public void setCabinType(CabinType cabinType) {
            this.cabinType = cabinType;
        }

        /** 
         * Get the 'ClassOfService' element value.
         * 
         * @return value
         */
        public FlightCOSCoreType getClassOfService() {
            return classOfService;
        }

        /** 
         * Set the 'ClassOfService' element value.
         * 
         * @param classOfService
         */
        public void setClassOfService(FlightCOSCoreType classOfService) {
            this.classOfService = classOfService;
        }

        /** 
         * Get the 'Details' element value. Flight Details.
         * 
         * @return value
         */
        public FlightDetailType getDetails() {
            return details;
        }

        /** 
         * Set the 'Details' element value. Flight Details.
         * 
         * @param details
         */
        public void setDetails(FlightDetailType details) {
            this.details = details;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }

        /** 
         * Get the 'PricingInd' attribute value. When TRUE, this flight OD pair should be priced.
         * 
         * @return value
         */
        public Boolean getPricingInd() {
            return pricingInd;
        }

        /** 
         * Set the 'PricingInd' attribute value. When TRUE, this flight OD pair should be priced.
         * 
         * @param pricingInd
         */
        public void setPricingInd(Boolean pricingInd) {
            this.pricingInd = pricingInd;
        }

        /** 
         * Get the 'ConnectionInd' attribute value. 
                              When TRUE, there are one or more connections for this flight.
                            
         * 
         * @return value
         */
        public Boolean getConnectionInd() {
            return connectionInd;
        }

        /** 
         * Set the 'ConnectionInd' attribute value. 
                              When TRUE, there are one or more connections for this flight.
                            
         * 
         * @param connectionInd
         */
        public void setConnectionInd(Boolean connectionInd) {
            this.connectionInd = connectionInd;
        }

        /** 
         * Get the 'E_TicketInd' attribute value. When TRUE, an electronic ticket may be issued.
         * 
         * @return value
         */
        public Boolean getETicketInd() {
            return ETicketInd;
        }

        /** 
         * Set the 'E_TicketInd' attribute value. When TRUE, an electronic ticket may be issued.
         * 
         * @param ETicketInd
         */
        public void setETicketInd(Boolean ETicketInd) {
            this.ETicketInd = ETicketInd;
        }

        /** 
         * Get the 'TicketlessInd' attribute value. 
                              When TRUE, the fare can be purchased without issuing a ticket.
                            
         * 
         * @return value
         */
        public Boolean getTicketlessInd() {
            return ticketlessInd;
        }

        /** 
         * Set the 'TicketlessInd' attribute value. 
                              When TRUE, the fare can be purchased without issuing a ticket.
                            
         * 
         * @param ticketlessInd
         */
        public void setTicketlessInd(Boolean ticketlessInd) {
            this.ticketlessInd = ticketlessInd;
        }
        /** 
         * The carrier that operates a flight with a reference to its own prime flight number.

        Note: Operating Carrier may be different from a Marketing Carrier(s), if the flight is actually marketed by another carrier(s) within a codeshare agreement. 

        Operating Carrier may not be the AOC holder, in which case, and wherever required, this will need to be disclosed to the customer.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingCarrier" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:OperatingCarrierFlightType">
         *         &lt;xs:sequence>
         *           &lt;xs:element ref="ns:Disclosures" minOccurs="0"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OperatingCarrier extends OperatingCarrierFlightType
            implements Serializable
        {
            private DisclosureType disclosures;

            /** 
             * Get the 'Disclosures' element value.
             * 
             * @return value
             */
            public DisclosureType getDisclosures() {
                return disclosures;
            }

            /** 
             * Set the 'Disclosures' element value.
             * 
             * @param disclosures
             */
            public void setDisclosures(DisclosureType disclosures) {
                this.disclosures = disclosures;
            }
        }
    }
    /** 
     * Aircraft Equipment information, e. g. 733, 346. Refers to details and codes listed in Standard Schedules Information Manual (SSIM), Appendix A.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AircraftEquipment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:AircraftCode"/>
     *       &lt;xs:element type="xs:string" name="AirlineEquipCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AircraftEquipment implements Serializable
    {
        private AircraftCodeType aircraftCode;
        private String airlineEquipCode;
        private String name;

        /** 
         * Get the 'AircraftCode' element value. 
                          Aircraft Equipment Code. Example: 737 Encoding Scheme: IATA/ A4A Aircraft Equipment Code
                        
         * 
         * @return value
         */
        public AircraftCodeType getAircraftCode() {
            return aircraftCode;
        }

        /** 
         * Set the 'AircraftCode' element value. 
                          Aircraft Equipment Code. Example: 737 Encoding Scheme: IATA/ A4A Aircraft Equipment Code
                        
         * 
         * @param aircraftCode
         */
        public void setAircraftCode(AircraftCodeType aircraftCode) {
            this.aircraftCode = aircraftCode;
        }

        /** 
         * Get the 'AirlineEquipCode' element value. 
                          Airline-specific aircraft equipment code. Example: 737-800
                        
         * 
         * @return value
         */
        public String getAirlineEquipCode() {
            return airlineEquipCode;
        }

        /** 
         * Set the 'AirlineEquipCode' element value. 
                          Airline-specific aircraft equipment code. Example: 737-800
                        
         * 
         * @param airlineEquipCode
         */
        public void setAirlineEquipCode(String airlineEquipCode) {
            this.airlineEquipCode = airlineEquipCode;
        }

        /** 
         * Get the 'Name' element value. Aircraft name. Example: Boeing 737-800
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Aircraft name. Example: Boeing 737-800
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
    /** 
     * 
                  Passenger(s)/ Group associated with the Offer Item. Note: This contains references to Passenger and Group instance(s) defined in the Passengers node.
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:PassengerReference"/>
     *       &lt;xs:element ref="ns:GroupReference"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Passengers implements Serializable
    {
        private PassengerReference passengerReference;
        private GroupReference groupReference;

        /** 
         * Get the 'PassengerReference' element value. 
                          Association to multiple Passenger instance(s). Example: pax1 pax2
                        
         * 
         * @return value
         */
        public PassengerReference getPassengerReference() {
            return passengerReference;
        }

        /** 
         * Set the 'PassengerReference' element value. 
                          Association to multiple Passenger instance(s). Example: pax1 pax2
                        
         * 
         * @param passengerReference
         */
        public void setPassengerReference(PassengerReference passengerReference) {
            this.passengerReference = passengerReference;
        }

        /** 
         * Get the 'GroupReference' element value.
         * 
         * @return value
         */
        public GroupReference getGroupReference() {
            return groupReference;
        }

        /** 
         * Set the 'GroupReference' element value.
         * 
         * @param groupReference
         */
        public void setGroupReference(GroupReference groupReference) {
            this.groupReference = groupReference;
        }
    }
    /** 
     * 
                  Offer Item details including wait list indicator and inventory guarantee.
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Details" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="InventoryGuarantee" minOccurs="0">
     *         &lt;!-- Reference to inner class InventoryGuarantee -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="WaitListInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Details implements Serializable
    {
        private InventoryGuarantee inventoryGuarantee;
        private Boolean waitListInd;

        /** 
         * Get the 'InventoryGuarantee' element value.
         * 
         * @return value
         */
        public InventoryGuarantee getInventoryGuarantee() {
            return inventoryGuarantee;
        }

        /** 
         * Set the 'InventoryGuarantee' element value.
         * 
         * @param inventoryGuarantee
         */
        public void setInventoryGuarantee(InventoryGuarantee inventoryGuarantee) {
            this.inventoryGuarantee = inventoryGuarantee;
        }

        /** 
         * Get the 'WaitListInd' attribute value. When TRUE, this offer item is waitlisted.
         * 
         * @return value
         */
        public Boolean getWaitListInd() {
            return waitListInd;
        }

        /** 
         * Set the 'WaitListInd' attribute value. When TRUE, this offer item is waitlisted.
         * 
         * @param waitListInd
         */
        public void setWaitListInd(Boolean waitListInd) {
            this.waitListInd = waitListInd;
        }
        /** 
         * Inventory Guarantee 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InventoryGuarantee" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="InvGuaranteeID"/>
         *       &lt;xs:element ref="ns:InvGuaranteeTimeLimits"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class InventoryGuarantee implements Serializable
        {
            private String invGuaranteeID;
            private CoreDateGrpType invGuaranteeTimeLimits;

            /** 
             * Get the 'InvGuaranteeID' element value. 
                                  Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
                                
             * 
             * @return value
             */
            public String getInvGuaranteeID() {
                return invGuaranteeID;
            }

            /** 
             * Set the 'InvGuaranteeID' element value. 
                                  Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
                                
             * 
             * @param invGuaranteeID
             */
            public void setInvGuaranteeID(String invGuaranteeID) {
                this.invGuaranteeID = invGuaranteeID;
            }

            /** 
             * Get the 'InvGuaranteeTimeLimits' element value.
             * 
             * @return value
             */
            public CoreDateGrpType getInvGuaranteeTimeLimits() {
                return invGuaranteeTimeLimits;
            }

            /** 
             * Set the 'InvGuaranteeTimeLimits' element value.
             * 
             * @param invGuaranteeTimeLimits
             */
            public void setInvGuaranteeTimeLimits(
                    CoreDateGrpType invGuaranteeTimeLimits) {
                this.invGuaranteeTimeLimits = invGuaranteeTimeLimits;
            }
        }
    }
}
