
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * FLIGHT ON-TIME PERFORMANCE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightPerformanceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="Low" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="High" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="NewFlightInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="NoDataInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="NotRequiredInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightPerformanceType implements Serializable
{
    private BigDecimal low;
    private BigDecimal high;
    private Boolean newFlightInd;
    private Boolean noDataInd;
    private Boolean notRequiredInd;

    /** 
     * Get the 'Low' element value. On-time Percentage Low Value. Example: 70 (70 Percentage)
     * 
     * @return value
     */
    public BigDecimal getLow() {
        return low;
    }

    /** 
     * Set the 'Low' element value. On-time Percentage Low Value. Example: 70 (70 Percentage)
     * 
     * @param low
     */
    public void setLow(BigDecimal low) {
        this.low = low;
    }

    /** 
     * Get the 'High' element value. On-time Percentage High Value. Example: 79 (79 Percentage)
     * 
     * @return value
     */
    public BigDecimal getHigh() {
        return high;
    }

    /** 
     * Set the 'High' element value. On-time Percentage High Value. Example: 79 (79 Percentage)
     * 
     * @param high
     */
    public void setHigh(BigDecimal high) {
        this.high = high;
    }

    /** 
     * Get the 'NewFlightInd' attribute value. When TRUE, this is a new flight and no performance information is available.
     * 
     * @return value
     */
    public Boolean getNewFlightInd() {
        return newFlightInd;
    }

    /** 
     * Set the 'NewFlightInd' attribute value. When TRUE, this is a new flight and no performance information is available.
     * 
     * @param newFlightInd
     */
    public void setNewFlightInd(Boolean newFlightInd) {
        this.newFlightInd = newFlightInd;
    }

    /** 
     * Get the 'NoDataInd' attribute value. When TRUE, no flight performance information is available.
     * 
     * @return value
     */
    public Boolean getNoDataInd() {
        return noDataInd;
    }

    /** 
     * Set the 'NoDataInd' attribute value. When TRUE, no flight performance information is available.
     * 
     * @param noDataInd
     */
    public void setNoDataInd(Boolean noDataInd) {
        this.noDataInd = noDataInd;
    }

    /** 
     * Get the 'NotRequiredInd' attribute value. When TRUE, this is an international flight or location where no performance reporting is required.
     * 
     * @return value
     */
    public Boolean getNotRequiredInd() {
        return notRequiredInd;
    }

    /** 
     * Set the 'NotRequiredInd' attribute value. When TRUE, this is an international flight or location where no performance reporting is required.
     * 
     * @param notRequiredInd
     */
    public void setNotRequiredInd(Boolean notRequiredInd) {
        this.notRequiredInd = notRequiredInd;
    }
}
