
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The FlightPrice transaction set may return two different sets of content. Based on request attributes, the response may initially provide additional a la carte ancillary services that are applicable and available for the selected offer.

 If no ancillary services are available, the message returns a final pricing. If ancillary services are available, the modified pricing request includes selected services and returns a final pricing that includes service(s) selection. The response message also returns multi-media content at the message level with media references at the service level.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightPriceRS">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Document"/>
 *         &lt;xs:element type="ns:SuccessType" name="Success"/>
 *         &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *         &lt;xs:element type="ns:ProcessingResultType" name="Processing" minOccurs="0"/>
 *         &lt;xs:element type="ns:FltPriceResParamsType" name="Parameters" minOccurs="0"/>
 *         &lt;xs:element ref="ns:ShoppingResponseIDs" minOccurs="0"/>
 *         &lt;xs:element name="PricedFlightOffers" minOccurs="0">
 *           &lt;!-- Reference to inner class PricedFlightOffers -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="AirlineOffers" minOccurs="0">
 *           &lt;!-- Reference to inner class AirlineOffers -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Payments" minOccurs="0">
 *           &lt;!-- Reference to inner class Payments -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Promotions" minOccurs="0">
 *           &lt;!-- Reference to inner class Promotions -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:Commission" minOccurs="0"/>
 *         &lt;xs:element type="ns:DataListType" name="DataLists" minOccurs="0"/>
 *         &lt;xs:element type="ns:FltPriceResMetadataType" name="Metadata" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:element ref="ns:Errors"/>
 *     &lt;/xs:choice>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class FlightPriceRS implements Serializable
{
    private int choiceSelect = -1;
    private static final int DOCUMENT_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private MsgDocumentType document;
    private SuccessType success;
    private WarningsType warnings;
    private ProcessingResultType processing;
    private FltPriceResParamsType parameters;
    private ShoppingResponseIDType shoppingResponseIDs;
    private PricedFlightOffers pricedFlightOffers;
    private AirlineOffers airlineOffers;
    private Payments payments;
    private Promotions promotions;
    private Commission commission;
    private DataListType dataLists;
    private FltPriceResMetadataType metadata;
    private Policies policies;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Document is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDocument() {
        return choiceSelect == DOCUMENT_CHOICE;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.document = document;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'Processing' element value.
     * 
     * @return value
     */
    public ProcessingResultType getProcessing() {
        return processing;
    }

    /** 
     * Set the 'Processing' element value.
     * 
     * @param processing
     */
    public void setProcessing(ProcessingResultType processing) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.processing = processing;
    }

    /** 
     * Get the 'Parameters' element value. Search Result Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public FltPriceResParamsType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Search Result Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @param parameters
     */
    public void setParameters(FltPriceResParamsType parameters) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.parameters = parameters;
    }

    /** 
     * Get the 'ShoppingResponseIDs' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseIDs() {
        return shoppingResponseIDs;
    }

    /** 
     * Set the 'ShoppingResponseIDs' element value.
     * 
     * @param shoppingResponseIDs
     */
    public void setShoppingResponseIDs(
            ShoppingResponseIDType shoppingResponseIDs) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.shoppingResponseIDs = shoppingResponseIDs;
    }

    /** 
     * Get the 'PricedFlightOffers' element value.
     * 
     * @return value
     */
    public PricedFlightOffers getPricedFlightOffers() {
        return pricedFlightOffers;
    }

    /** 
     * Set the 'PricedFlightOffers' element value.
     * 
     * @param pricedFlightOffers
     */
    public void setPricedFlightOffers(PricedFlightOffers pricedFlightOffers) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.pricedFlightOffers = pricedFlightOffers;
    }

    /** 
     * Get the 'AirlineOffers' element value.
     * 
     * @return value
     */
    public AirlineOffers getAirlineOffers() {
        return airlineOffers;
    }

    /** 
     * Set the 'AirlineOffers' element value.
     * 
     * @param airlineOffers
     */
    public void setAirlineOffers(AirlineOffers airlineOffers) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.airlineOffers = airlineOffers;
    }

    /** 
     * Get the 'Payments' element value.
     * 
     * @return value
     */
    public Payments getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value.
     * 
     * @param payments
     */
    public void setPayments(Payments payments) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.payments = payments;
    }

    /** 
     * Get the 'Promotions' element value.
     * 
     * @return value
     */
    public Promotions getPromotions() {
        return promotions;
    }

    /** 
     * Set the 'Promotions' element value.
     * 
     * @param promotions
     */
    public void setPromotions(Promotions promotions) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.promotions = promotions;
    }

    /** 
     * Get the 'Commission' element value.
     * 
     * @return value
     */
    public Commission getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value.
     * 
     * @param commission
     */
    public void setCommission(Commission commission) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.commission = commission;
    }

    /** 
     * Get the 'DataLists' element value. Data Lists(s).
     * 
     * @return value
     */
    public DataListType getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value. Data Lists(s).
     * 
     * @param dataLists
     */
    public void setDataLists(DataListType dataLists) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public FltPriceResMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(FltPriceResMetadataType metadata) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.policies = policies;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * PRICED FLIGHT Airline Offer(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedFlightOffers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:PricedFlightOffer" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PricedFlightOffers implements Serializable
    {
        private List<PricedFlightOffer> pricedFlightOfferList = new ArrayList<PricedFlightOffer>();

        /** 
         * Get the list of 'PricedFlightOffer' element items. Priced Flight Offer detail.

        Notes:
        1. A Priced Flight Offer may contain Branded Fare information. If it is a Branded Fare, Price Class-association will be specified.

        2. Additionally, Lead Pricing Calendar fares (prior to and/ or after the specified departure date) may be specified by passenger type.
         * 
         * @return list
         */
        public List<PricedFlightOffer> getPricedFlightOfferList() {
            return pricedFlightOfferList;
        }

        /** 
         * Set the list of 'PricedFlightOffer' element items. Priced Flight Offer detail.

        Notes:
        1. A Priced Flight Offer may contain Branded Fare information. If it is a Branded Fare, Price Class-association will be specified.

        2. Additionally, Lead Pricing Calendar fares (prior to and/ or after the specified departure date) may be specified by passenger type.
         * 
         * @param list
         */
        public void setPricedFlightOfferList(List<PricedFlightOffer> list) {
            pricedFlightOfferList = list;
        }
    }
    /** 
     * Other Airline Offer(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineOffers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AirlineOffer" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AirlineOffer -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AirlineOffers implements Serializable
    {
        private List<AirlineOffer> airlineOfferList = new ArrayList<AirlineOffer>();

        /** 
         * Get the list of 'AirlineOffer' element items.
         * 
         * @return list
         */
        public List<AirlineOffer> getAirlineOfferList() {
            return airlineOfferList;
        }

        /** 
         * Set the list of 'AirlineOffer' element items.
         * 
         * @param list
         */
        public void setAirlineOfferList(List<AirlineOffer> list) {
            airlineOfferList = list;
        }
        /** 
         * Offer detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineOffer" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:OfferItemDetailType">
         *         &lt;xs:sequence>
         *           &lt;xs:element ref="ns:PricedOffer"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AirlineOffer extends OfferItemDetailType implements
            Serializable
        {
            private PricedFlightOfferType pricedOffer;

            /** 
             * Get the 'PricedOffer' element value.
             * 
             * @return value
             */
            public PricedFlightOfferType getPricedOffer() {
                return pricedOffer;
            }

            /** 
             * Set the 'PricedOffer' element value.
             * 
             * @param pricedOffer
             */
            public void setPricedOffer(PricedFlightOfferType pricedOffer) {
                this.pricedOffer = pricedOffer;
            }
        }
    }
    /** 
     * Payment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:OrderPaymentFormType" name="Payment" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payments implements Serializable
    {
        private List<OrderPaymentFormType> paymentList = new ArrayList<OrderPaymentFormType>();

        /** 
         * Get the list of 'Payment' element items. Payment detail, including association(s).
         * 
         * @return list
         */
        public List<OrderPaymentFormType> getPaymentList() {
            return paymentList;
        }

        /** 
         * Set the list of 'Payment' element items. Payment detail, including association(s).
         * 
         * @param list
         */
        public void setPaymentList(List<OrderPaymentFormType> list) {
            paymentList = list;
        }
    }
    /** 
     * Promotion information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PromotionType" name="Promotion" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Promotions implements Serializable
    {
        private List<PromotionType> promotionList = new ArrayList<PromotionType>();

        /** 
         * Get the list of 'Promotion' element items. Promotion Code.
         * 
         * @return list
         */
        public List<PromotionType> getPromotionList() {
            return promotionList;
        }

        /** 
         * Set the list of 'Promotion' element items. Promotion Code.
         * 
         * @param list
         */
        public void setPromotionList(List<PromotionType> list) {
            promotionList = list;
        }
    }
}
