
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Flight Price definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightPriceType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:CurrencyAmountOptType" name="BaseAmount" minOccurs="0"/>
 *         &lt;xs:element name="Surcharges" minOccurs="0">
 *           &lt;!-- Reference to inner class Surcharges -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
 *         &lt;xs:element ref="ns:TaxExemption" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightPriceType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private CurrencyAmountOptType baseAmount;
    private Surcharges surcharges;
    private TaxDetailType taxes;
    private TaxExemptionType taxExemption;

    /** 
     * Get the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @return value
     */
    public CurrencyAmountOptType getBaseAmount() {
        return baseAmount;
    }

    /** 
     * Set the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

    Note: This includes  surcharges (if applicable).
     * 
     * @param baseAmount
     */
    public void setBaseAmount(CurrencyAmountOptType baseAmount) {
        this.baseAmount = baseAmount;
    }

    /** 
     * Get the 'Surcharges' element value.
     * 
     * @return value
     */
    public Surcharges getSurcharges() {
        return surcharges;
    }

    /** 
     * Set the 'Surcharges' element value.
     * 
     * @param surcharges
     */
    public void setSurcharges(Surcharges surcharges) {
        this.surcharges = surcharges;
    }

    /** 
     * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @return value
     */
    public TaxDetailType getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
     * 
     * @param taxes
     */
    public void setTaxes(TaxDetailType taxes) {
        this.taxes = taxes;
    }

    /** 
     * Get the 'TaxExemption' element value.
     * 
     * @return value
     */
    public TaxExemptionType getTaxExemption() {
        return taxExemption;
    }

    /** 
     * Set the 'TaxExemption' element value.
     * 
     * @param taxExemption
     */
    public void setTaxExemption(TaxExemptionType taxExemption) {
        this.taxExemption = taxExemption;
    }
    /** 
     * Applicable Surcharge(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FeeSurchargeType" name="Surcharge" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Surcharges implements Serializable
    {
        private List<FeeSurchargeType> surchargeList = new ArrayList<FeeSurchargeType>();

        /** 
         * Get the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @return list
         */
        public List<FeeSurchargeType> getSurchargeList() {
            return surchargeList;
        }

        /** 
         * Set the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @param list
         */
        public void setSurchargeList(List<FeeSurchargeType> list) {
            surchargeList = list;
        }
    }
}
