
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Association to multiple Flight instance(s). Example: flight1 flight2

 Note: Flight Slice On and Off Board Points may also be specified.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightReferences">
 *   &lt;xs:complexType>
 *     &lt;xs:simpleContent>
 *       &lt;xs:extension base="xs:string">
 *         &lt;xs:attribute type="xs:string" use="optional" name="OnPoint"/>
 *         &lt;xs:attribute type="xs:string" use="optional" name="OffPoint"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:simpleContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class FlightReferences implements Serializable
{
    private String string;
    private String onPoint;
    private String offPoint;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'OnPoint' attribute value. Flight slice on point. Example: TPA

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @return value
     */
    public String getOnPoint() {
        return onPoint;
    }

    /** 
     * Set the 'OnPoint' attribute value. Flight slice on point. Example: TPA

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @param onPoint
     */
    public void setOnPoint(String onPoint) {
        this.onPoint = onPoint;
    }

    /** 
     * Get the 'OffPoint' attribute value. Flight slice off point. Example: LHR

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @return value
     */
    public String getOffPoint() {
        return offPoint;
    }

    /** 
     * Set the 'OffPoint' attribute value. Flight slice off point. Example: LHR

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @param offPoint
     */
    public void setOffPoint(String offPoint) {
        this.offPoint = offPoint;
    }
}
