
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Geographic Specification information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GeographicSpecificationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CodesetType" name="Type"/>
 *     &lt;xs:choice>
 *       &lt;xs:element name="Area"/>
 *       &lt;xs:element name="SubArea"/>
 *       &lt;xs:element ref="ns:CountryCode"/>
 *       &lt;xs:element ref="ns:CityCode"/>
 *       &lt;xs:element ref="ns:StateCode"/>
 *       &lt;xs:element ref="ns:AirportCode"/>
 *       &lt;xs:element type="ns:PositionType" name="Coordinates"/>
 *       &lt;xs:element name="CoordinateRadius"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GeographicSpecificationType implements Serializable
{
    private CodesetType type;
    private int choiceSelect = -1;
    private static final int AREA_CHOICE = 0;
    private static final int SUB_AREA_CHOICE = 1;
    private static final int COUNTRY_CODE_CHOICE = 2;
    private static final int CITY_CODE_CHOICE = 3;
    private static final int STATE_CODE_CHOICE = 4;
    private static final int AIRPORT_CODE_CHOICE = 5;
    private static final int COORDINATES_CHOICE = 6;
    private static final int COORDINATE_RADIUS_CHOICE = 7;
    private boolean area;
    private boolean subArea;
    private CountryCodeType countryCode;
    private CityCodeType cityCode;
    private StateCode stateCode;
    private AirportCode airportCode;
    private PositionType coordinates;
    private boolean coordinateRadius;

    /** 
     * Get the 'Type' element value. A code indicating the type of geographic specification that will be found in the following fields.                          Blank or A = Area S = State SA = Sub Area C = City N = Country CO = Coordinates
     * 
     * @return value
     */
    public CodesetType getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. A code indicating the type of geographic specification that will be found in the following fields.                          Blank or A = Area S = State SA = Sub Area C = City N = Country CO = Coordinates
     * 
     * @param type
     */
    public void setType(CodesetType type) {
        this.type = type;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Area is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifArea() {
        return choiceSelect == AREA_CHOICE;
    }

    /** 
     * Check if the 'Area' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifAreaPresent() {
        return area;
    }

    /** 
     * Set flag for 'Area' element present.
     * 
     * @param area
     */
    public void flagAreaPresent(boolean area) {
        setChoiceSelect(AREA_CHOICE);
        this.area = area;
    }

    /** 
     * Check if SubArea is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSubArea() {
        return choiceSelect == SUB_AREA_CHOICE;
    }

    /** 
     * Check if the 'SubArea' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifSubAreaPresent() {
        return subArea;
    }

    /** 
     * Set flag for 'SubArea' element present.
     * 
     * @param subArea
     */
    public void flagSubAreaPresent(boolean subArea) {
        setChoiceSelect(SUB_AREA_CHOICE);
        this.subArea = subArea;
    }

    /** 
     * Check if CountryCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCountryCode() {
        return choiceSelect == COUNTRY_CODE_CHOICE;
    }

    /** 
     * Get the 'CountryCode' element value.
     * 
     * @return value
     */
    public CountryCodeType getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value.
     * 
     * @param countryCode
     */
    public void setCountryCode(CountryCodeType countryCode) {
        setChoiceSelect(COUNTRY_CODE_CHOICE);
        this.countryCode = countryCode;
    }

    /** 
     * Check if CityCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCityCode() {
        return choiceSelect == CITY_CODE_CHOICE;
    }

    /** 
     * Get the 'CityCode' element value.
     * 
     * @return value
     */
    public CityCodeType getCityCode() {
        return cityCode;
    }

    /** 
     * Set the 'CityCode' element value.
     * 
     * @param cityCode
     */
    public void setCityCode(CityCodeType cityCode) {
        setChoiceSelect(CITY_CODE_CHOICE);
        this.cityCode = cityCode;
    }

    /** 
     * Check if StateCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifStateCode() {
        return choiceSelect == STATE_CODE_CHOICE;
    }

    /** 
     * Get the 'StateCode' element value.
     * 
     * @return value
     */
    public StateCode getStateCode() {
        return stateCode;
    }

    /** 
     * Set the 'StateCode' element value.
     * 
     * @param stateCode
     */
    public void setStateCode(StateCode stateCode) {
        setChoiceSelect(STATE_CODE_CHOICE);
        this.stateCode = stateCode;
    }

    /** 
     * Check if AirportCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirportCode() {
        return choiceSelect == AIRPORT_CODE_CHOICE;
    }

    /** 
     * Get the 'AirportCode' element value.
     * 
     * @return value
     */
    public AirportCode getAirportCode() {
        return airportCode;
    }

    /** 
     * Set the 'AirportCode' element value.
     * 
     * @param airportCode
     */
    public void setAirportCode(AirportCode airportCode) {
        setChoiceSelect(AIRPORT_CODE_CHOICE);
        this.airportCode = airportCode;
    }

    /** 
     * Check if Coordinates is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCoordinates() {
        return choiceSelect == COORDINATES_CHOICE;
    }

    /** 
     * Get the 'Coordinates' element value. Coordinates (Latitude, Longitude, as defined in the Data Dictionary)
     * 
     * @return value
     */
    public PositionType getCoordinates() {
        return coordinates;
    }

    /** 
     * Set the 'Coordinates' element value. Coordinates (Latitude, Longitude, as defined in the Data Dictionary)
     * 
     * @param coordinates
     */
    public void setCoordinates(PositionType coordinates) {
        setChoiceSelect(COORDINATES_CHOICE);
        this.coordinates = coordinates;
    }

    /** 
     * Check if CoordinateRadius is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCoordinateRadius() {
        return choiceSelect == COORDINATE_RADIUS_CHOICE;
    }

    /** 
     * Check if the 'CoordinateRadius' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifCoordinateRadiusPresent() {
        return coordinateRadius;
    }

    /** 
     * Set flag for 'CoordinateRadius' element present.
     * 
     * @param coordinateRadius
     */
    public void flagCoordinateRadiusPresent(boolean coordinateRadius) {
        setChoiceSelect(COORDINATE_RADIUS_CHOICE);
        this.coordinateRadius = coordinateRadius;
    }
}
