
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Request Message Parameters.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItinReshopParamsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Alerts" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:PinPhraseAnswerType" name="PIN_AuthAlertResponse" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="Notices" minOccurs="0">
 *       &lt;!-- Reference to inner class Notices -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ItinReshopParamsType implements Serializable
{
    private PinPhraseAnswerType alerts;
    private Notices notices;
    private String refs;

    /** 
     * Get the 'PIN_AuthAlertResponse' element value. Traveler PIN Phrase Authentication Response.

    Notes:
    1. This is part of an ongoing transaction for a processing condition that occured when additional Traveler authentication was required to complete transaction processing, such as access to secure FQTV information to complete Order amendment.
    2. This information contains the authentication scheme response information, e.g. the Pin Phrase answer.
     * 
     * @return value
     */
    public PinPhraseAnswerType getAlerts() {
        return alerts;
    }

    /** 
     * Set the 'PIN_AuthAlertResponse' element value. Traveler PIN Phrase Authentication Response.

    Notes:
    1. This is part of an ongoing transaction for a processing condition that occured when additional Traveler authentication was required to complete transaction processing, such as access to secure FQTV information to complete Order amendment.
    2. This information contains the authentication scheme response information, e.g. the Pin Phrase answer.
     * 
     * @param alerts
     */
    public void setAlerts(PinPhraseAnswerType alerts) {
        this.alerts = alerts;
    }

    /** 
     * Get the 'Notices' element value.
     * 
     * @return value
     */
    public Notices getNotices() {
        return notices;
    }

    /** 
     * Set the 'Notices' element value.
     * 
     * @param notices
     */
    public void setNotices(Notices notices) {
        this.notices = notices;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Transaction Processing Notice(s).

    Note: These notices contain requested transaction processing parameters that may be ignored by EDIST-enabled systems that do not support the capability.

     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Notices" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:NoticeBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="PricingParameters" minOccurs="0">
     *             &lt;!-- Reference to inner class PricingParameters -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Notices extends NoticeBaseType implements Serializable
    {
        private PricingParameters pricingParameters;

        /** 
         * Get the 'PricingParameters' element value.
         * 
         * @return value
         */
        public PricingParameters getPricingParameters() {
            return pricingParameters;
        }

        /** 
         * Set the 'PricingParameters' element value.
         * 
         * @param pricingParameters
         */
        public void setPricingParameters(PricingParameters pricingParameters) {
            this.pricingParameters = pricingParameters;
        }
        /** 
         * Pricing Parameters Notice.

        Note: Supports specifying transaction pricing parameters. Request messages may include indicators requesting that certain methods be applied during payment processing where relevant. Response messages may additionally include notice about if and how pricing parameters were applied during transaction processing.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingParameters" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="AutoExchRequestInd"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="IncludeAwardRequestInd"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="AwardOnlyRequestInd"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="SimpleRequestInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricingParameters implements Serializable
        {
            private Boolean autoExchRequestInd;
            private Boolean includeAwardRequestInd;
            private Boolean awardOnlyRequestInd;
            private Boolean simpleRequestInd;

            /** 
             * Get the 'AutoExchRequestInd' attribute value. When TRUE, this request is to be handled by an auto-exchange process.
             * 
             * @return value
             */
            public Boolean getAutoExchRequestInd() {
                return autoExchRequestInd;
            }

            /** 
             * Set the 'AutoExchRequestInd' attribute value. When TRUE, this request is to be handled by an auto-exchange process.
             * 
             * @param autoExchRequestInd
             */
            public void setAutoExchRequestInd(Boolean autoExchRequestInd) {
                this.autoExchRequestInd = autoExchRequestInd;
            }

            /** 
             * Get the 'IncludeAwardRequestInd' attribute value. When TRUE, award eligible in addition to priced offers and fares is requested.
             * 
             * @return value
             */
            public Boolean getIncludeAwardRequestInd() {
                return includeAwardRequestInd;
            }

            /** 
             * Set the 'IncludeAwardRequestInd' attribute value. When TRUE, award eligible in addition to priced offers and fares is requested.
             * 
             * @param includeAwardRequestInd
             */
            public void setIncludeAwardRequestInd(Boolean includeAwardRequestInd) {
                this.includeAwardRequestInd = includeAwardRequestInd;
            }

            /** 
             * Get the 'AwardOnlyRequestInd' attribute value. When TRUE, only award eligible offers/ fares are requested.
             * 
             * @return value
             */
            public Boolean getAwardOnlyRequestInd() {
                return awardOnlyRequestInd;
            }

            /** 
             * Set the 'AwardOnlyRequestInd' attribute value. When TRUE, only award eligible offers/ fares are requested.
             * 
             * @param awardOnlyRequestInd
             */
            public void setAwardOnlyRequestInd(Boolean awardOnlyRequestInd) {
                this.awardOnlyRequestInd = awardOnlyRequestInd;
            }

            /** 
             * Get the 'SimpleRequestInd' attribute value. When TRUE, Simple Pricing  for flight offers is requested.
             * 
             * @return value
             */
            public Boolean getSimpleRequestInd() {
                return simpleRequestInd;
            }

            /** 
             * Set the 'SimpleRequestInd' attribute value. When TRUE, Simple Pricing  for flight offers is requested.
             * 
             * @param simpleRequestInd
             */
            public void setSimpleRequestInd(Boolean simpleRequestInd) {
                this.simpleRequestInd = simpleRequestInd;
            }
        }
    }
}
